package com.xebialabs.deployit.plugin.overthere;

import com.xebialabs.deployit.plugin.api.validation.ValidationContext;

import java.util.Arrays;
import java.util.List;

public abstract class BaseValidator implements com.xebialabs.deployit.plugin.api.validation.Validator<Host>{

    private List<String> supportedProtocols = Arrays.asList("smb", "cifs");

    @Override
    public void validate(Host value, ValidationContext context) {
        String protocol = value.getProperty("protocol");
        if (supportedProtocols.contains(protocol)) {
            validate(value, context, protocol.toUpperCase());
        }
    }

    protected abstract void validate(Host value, ValidationContext context, String protocol);
}
