package com.xebialabs.deployit.plugin.credentials.gcp;

import java.util.function.BiConsumer;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION;

@Metadata(root = CONFIGURATION, description = "Credentials for Service Account from JSON string")
public class ServiceAccountJsonGcpCredentials extends GcpHostCredentials {
    @Property(label = "Service Account Credentials JSON", size = Property.Size.LARGE)
    private String credentialsJson;

    public String getCredentialsJson() {
        return credentialsJson;
    }

    public void setCredentialsJson(final String credentialsJson) {
        this.credentialsJson = credentialsJson;
    }

    public void applyProperties(BiConsumer<String, String> consumer) {
        super.applyProperties(consumer);
        consumer.accept("gcpCredentialsType", "ServiceAccountJson");
        consumer.accept("credentialsJson", getCredentialsJson());
    }
}
