/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.overthere;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Delegate;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.overthere.step.ZosCheckCommandExecutionStep;
import com.xebialabs.deployit.plugin.overthere.step.ZosCheckFileEncoding;
import com.xebialabs.deployit.plugin.overthere.step.ZosCheckFileTransferStep;
import com.xebialabs.overthere.ssh.SshConnectionType;
import com.xebialabs.overthere.ssh.SshZosConnectionType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ZosCheckConnectionDelegate {
    private static final Logger log = Logger.getLogger(ZosCheckConnectionDelegate.class);

    private ZosCheckConnectionDelegate() {
    }

    @Delegate(name="zosConnectionChecker")
    public static List<Step> executedScriptDelegate(ConfigurationItem item, String name, Map<String, String> args, Parameters params) {
        ArrayList<Step> zosCheckConnectionSteps;
        Checks.checkArgument((boolean)(item instanceof Host), (String)"the connectionChecker delegate is for 'overthere.Host' subtypes only", (Object[])new Object[0]);
        if (!item.hasProperty("zosConnectionType") || item.getProperty("zosConnectionType") == null || item.getProperty("zosConnectionType") != SshZosConnectionType.SFTP) {
            log.error((Object)("ZOSCONN: The zosConnectionType is not initialized expecting SFTP " + item.getProperty("zosConnectionType")));
            ArrayList<Step> zosCheckConnectionSteps2 = new ArrayList<Step>();
            return zosCheckConnectionSteps2;
        }
        if (item.hasProperty("connectionType") && item.getProperty("connectionType") != null && item.getProperty("connectionType") == SshConnectionType.SFTP) {
            zosCheckConnectionSteps = ZosCheckConnectionDelegate.newStepsForSFTP((Host)item);
            zosCheckConnectionSteps.add((Step)new ZosCheckFileEncoding((Host)item));
        } else {
            zosCheckConnectionSteps = new ArrayList<Step>();
            log.error((Object)("ZOSCONN: The connectionType is not initialized expecting SFTP DEFAULT " + item.getProperty("connectionType")));
        }
        return zosCheckConnectionSteps;
    }

    private static ArrayList<Step> newStepsForSFTP(Host item) {
        return Lists.newArrayList((Object[])new Step[]{new ZosCheckFileTransferStep(item), new ZosCheckCommandExecutionStep(item)});
    }
}

