/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.credentials.gcp;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.credentials.gcp.GcpHostCredentials;
import java.util.function.BiConsumer;

@Metadata(root=Metadata.ConfigurationItemRoot.CONFIGURATION, description="Credentials for Service Account from properties")
public class ServiceAccountPkcs8GcpCredentials
extends GcpHostCredentials {
    @Property(label="Project ID")
    private String projectId;
    @Property(label="Client ID of the service account")
    private String clientId;
    @Property(label="Client email address of the service account")
    private String clientEmail;
    @Property(label="RSA private key object for the service account in PKCS#8 format", size=Property.Size.LARGE)
    private String privateKeyPkcs8;
    @Property(label="Private key identifier for the service account")
    private String privateKeyId;
    @Property(label="Scopes, comma separated list, for the APIs to be called", required=false)
    private String scopes;
    @Property(label="URI of the end point that provides tokens", required=false)
    private String tokenServerUri;
    @Property(label="The email of the user account to impersonate, if delegating domain-wide authority to the service account", required=false)
    private String serviceAccountUser;

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientEmail() {
        return this.clientEmail;
    }

    public void setClientEmail(String clientEmail) {
        this.clientEmail = clientEmail;
    }

    public String getPrivateKeyPkcs8() {
        return this.privateKeyPkcs8;
    }

    public void setPrivateKeyPkcs8(String privateKeyPkcs8) {
        this.privateKeyPkcs8 = privateKeyPkcs8;
    }

    public String getPrivateKeyId() {
        return this.privateKeyId;
    }

    public void setPrivateKeyId(String privateKeyId) {
        this.privateKeyId = privateKeyId;
    }

    public String getScopes() {
        return this.scopes;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public String getTokenServerUri() {
        return this.tokenServerUri;
    }

    public void setTokenServerUri(String tokenServerUri) {
        this.tokenServerUri = tokenServerUri;
    }

    public String getServiceAccountUser() {
        return this.serviceAccountUser;
    }

    public void setServiceAccountUser(String serviceAccountUser) {
        this.serviceAccountUser = serviceAccountUser;
    }

    public void applyProperties(BiConsumer<String, String> consumer) {
        super.applyProperties(consumer);
        consumer.accept("gcpCredentialsType", "ServiceAccountPkcs8");
        consumer.accept("projectId", this.getProjectId());
        consumer.accept("clientId", this.getClientId());
        consumer.accept("clientEmail", this.getClientEmail());
        consumer.accept("privateKeyPkcs8", this.getPrivateKeyPkcs8());
        consumer.accept("privateKeyId", this.getPrivateKeyId());
        consumer.accept("scopes", this.getScopes());
        if (this.getTokenServerUri() != null) {
            consumer.accept("tokenServerUri", this.getTokenServerUri());
        } else {
            consumer.accept("tokenServerUri", "https://oauth2.googleapis.com/token");
        }
        consumer.accept("serviceAccountUser", this.getServiceAccountUser());
    }
}

