package com.xebialabs.deployit.plugin.credentials.gcp;

import java.util.function.BiConsumer;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION;

@Metadata(root = CONFIGURATION, description = "Credentials for Service Account from JSON file")
public class ServiceAccountFileGcpCredentials extends GcpHostCredentials {
    @Property(label = "Service Account Credentials JSON File")
    private String  credentialsFile;

    public String getCredentialsFile() {
        return credentialsFile;
    }

    public void setCredentialsFile(final String credentialsFile) {
        this.credentialsFile = credentialsFile;
    }

    public void applyProperties(BiConsumer<String, String> consumer) {
        super.applyProperties(consumer);
        consumer.accept("gcpCredentialsType", "ServiceAccountJsonFile");
        consumer.accept("credentialsFile", getCredentialsFile());
    }
}
