package com.xebialabs.deployit.plugin.credentials.gcp;

import java.util.function.BiConsumer;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION;

@Metadata(root = CONFIGURATION, description = "Token Based Credentials Authentication from xl-deploy environment")
public class ServiceAccountTokenGcpCredentials extends GcpHostCredentials {
    @Property(label = "Project ID")
    private String projectId;
    @Property(label = "ApiToken")
    private String apiToken;
    @Property(label = "Client email address of the service account")
    private String clientEmail;

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(final String projectId) {
        this.projectId = projectId;
    }

    public String getApiToken() {
        return apiToken;
    }

    public void setApiToken(final String apiToken) {
        this.apiToken = apiToken;
    }

    public String getClientEmail() {
        return clientEmail;
    }

    public void setClientEmail(final String clientEmail) {
        this.clientEmail = clientEmail;
    }

    public void applyProperties(BiConsumer<String, String> consumer) {
        super.applyProperties(consumer);
        consumer.accept("gcpCredentialsType", "ServiceAccountToken");
        consumer.accept("projectId", getProjectId());
        consumer.accept("apiToken", getApiToken());
        consumer.accept("clientEmail", getClientEmail());
    }
}
