package com.xebialabs.deployit.plugin.test.yak.ci;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItemWithPolicies;

import java.util.List;

@SuppressWarnings("serial")
@Metadata(root = Metadata.ConfigurationItemRoot.INFRASTRUCTURE)
public class HerdWithPolicies extends BaseConfigurationItemWithPolicies implements HerdBase {

    @Property(description = "Do a suicide of entire herd.", required = false)
    protected boolean doKillingStampede;

    @ControlTask(parameterType = "yak.HerdParameters")
    public List<Step> breedHerd(final HerdParameters params) {
        return doKillingStampede ? stampedeApocalypse() : breed(params);
    }

    public boolean isDoKillingStampede() {
        return doKillingStampede;
    }

    public void setDoKillingStampede(boolean doKillingStampede) {
        this.doKillingStampede = doKillingStampede;
    }
}
