package com.xebialabs.deployit.plugin.test.v3;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableFileArtifact;
import com.xebialabs.deployit.plugin.test.v3.step.DummyLoggingStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Sets.newHashSet;

/**
 * Represents an Java EE EAR file.
 */
@SuppressWarnings("serial")
@Metadata(description = "Deployable EAR artifact.")
public class DummyEar extends BaseDeployableFileArtifact {

    private Logger logger = LoggerFactory.getLogger(DummyEar.class);

    public static final String ARCHIVE_EXTENSION = "ear";

    @Property(asContainment = true, required = false)
    private Set<Portlet> portlets = newHashSet();

    public Set<Portlet> getPortlets() {
        return portlets;
    }

    @Property(required = false, defaultValue = "false")
    private boolean failToDeployOnDummyJeeServer = false;

    public boolean getFailToDeployOnDummyJeeServer() {
        logger.info("Failure on " + getId() + " is set to " + failToDeployOnDummyJeeServer);
        return failToDeployOnDummyJeeServer;
    }

    public void setFailToDeployOnDummyJeeServer(Boolean failToDeployOnDummyJeeServer) {
        logger.info("Setting failure on " + getId() + " to " + failToDeployOnDummyJeeServer);
        this.failToDeployOnDummyJeeServer = failToDeployOnDummyJeeServer;
        logger.info("Failure on " + getId() + " is now set to " + getFailToDeployOnDummyJeeServer());
    }

    @ControlTask(description = "Do some control task logging")
    public List<Step> dummyControlTask(final TemplateParameters params) {

        ArrayList<Step> result = newArrayList();
        result.add(new DummyLoggingStep(1000, 1));
        result.add(new DummyLoggingStep(500, 2));
        result.add(new DummyLoggingStep(3000, 1));

        return result;
    }
}
