package com.xebialabs.deployit.sql.base.schema

import com.xebialabs.deployit.core.sql.ColumnName
import com.xebialabs.deployit.core.sql.TableName

object ActiveTaskSchema {

  val tableName: TableName = TableName("XLD_ACTIVE_TASKS")

  val task_id: ColumnName = ColumnName("task_id")
  val description: ColumnName = ColumnName("description")
  val task_owner: ColumnName = ColumnName("task_owner")
  val worker_id: ColumnName = ColumnName("worker_id")
}

object ActiveTaskMetadataSchema {

  val tableName: TableName = TableName("XLD_ACTIVE_TASKS_METADATA")

  val task_id: ColumnName = ColumnName("task_id")
  val metadata_key: ColumnName = ColumnName("metadata_key")
  val metadata_value: ColumnName = ColumnName("metadata_value")
}

object ActiveTaskMetadataKey {
  val APPLICATION_INTERNAL_ID: String = "application_internal_id"
  val ENVIRONMENT_INTERNAL_ID: String = "environment_internal_id"
  val CONTROL_TASK_TARGET_INTERNAL_CI: String = "controlTaskTargetInternalCI"
}

object ActiveTaskStatusSchema {

  val tableName: TableName = TableName("XLD_ACTIVE_TASK_STATUS")

  val taskId: ColumnName = ColumnName("TASK_ID")
  val path: ColumnName = ColumnName("PATH")
  val status: ColumnName = ColumnName("STATUS")
}
