package com.xebialabs.deployit.hibernate.dialect

import org.hibernate.dialect.DerbyTenSevenDialect
import java.sql.Types
import org.hibernate.`type`.descriptor.sql.{CharTypeDescriptor, ClobTypeDescriptor, SqlTypeDescriptor, VarcharTypeDescriptor}

class DeployDerbyDialect() extends DerbyTenSevenDialect {
  this.registerColumnType(Types.NVARCHAR, "varchar($l)")

  override protected def getSqlTypeDescriptorOverride(sqlCode: Int): SqlTypeDescriptor = sqlCode match {
    case -15 =>
      CharTypeDescriptor.INSTANCE
    case -9 =>
      VarcharTypeDescriptor.INSTANCE
    case 2011 =>
      if (this.useInputStreamToInsertBlob) return ClobTypeDescriptor.STREAM_BINDING
      ClobTypeDescriptor.CLOB_BINDING
    case _ =>
      super.getSqlTypeDescriptorOverride(sqlCode)
  }
}