package com.xebialabs.deployit.core.sql

import org.slf4j.LoggerFactory

abstract class Pageable {
  implicit def schemaInfo: SchemaInfo

  private val logger = LoggerFactory.getLogger(classOf[Pageable])

  protected var page: Option[Page] = None

  def getPage: Option[Page] = page

  def showPage(page: Int, pageSize: Int): this.type = {
    if (pageSize > 0) {
      require(page > 0, "Page should be larger than 0")
      this.page = Some(Page(page, pageSize))
    } else if (pageSize > 100) {
      logger.warn("The maximum page size is 100. Your result will be limited to this limit.")
      this.page = Some(Page(page, 100))
    }
    this
  }

  protected def addPaging(query: String): String = page match {
    case Some(Page(p, size)) if size > 0 => schemaInfo.sqlDialect.addPaging(query, p, size)
    case _ => query // Either no paging parameters, or a negative page size will lead to the entire result set being returned
  }

  def clearPage(): Unit = this.page = None
}
