package com.xebialabs.deployit.repository.sql

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.repository.SearchParameters
import com.xebialabs.license.LicenseCiCounter.LicensedCiUse

trait SqlLicenseUsageProvider {
  def getCiCount(ciType: Type): Int
  def licensedCisInUse(restrictedTypes: Map[Type, Int]): Array[LicensedCiUse]
}

class CiSqlLicenseUsageProvider(ciRepository: CiRepository) extends SqlLicenseUsageProvider {
  override def getCiCount(ciType: Type): Int = {
    val criteria = new SearchParameters()
    criteria.setType(ciType)
    ciRepository.count(criteria)
  }

  override def licensedCisInUse(restrictedTypes: Map[Type, Int]): Array[LicensedCiUse] = {
    restrictedTypes.map { case (ciType: Type, maxAllowed: Int) =>
      LicensedCiUse(`type` = ciType, allowedAmount = maxAllowed, actualAmount = getCiCount(ciType))
    }.toArray
  }
}
