package com.xebialabs.deployit.upgrade.sql

import com.xebialabs.deployit.booter.local.PluginVersions
import com.xebialabs.deployit.core.sql.{ColumnName, Queries, SchemaInfo, TableName}
import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.stereotype.Component
import org.springframework.transaction.annotation.Transactional

import java.sql.ResultSet
import scala.jdk.CollectionConverters._

@Component
@Transactional("mainTransactionManager")
class SqlRepositoryVersionService(@Autowired @Qualifier("mainJdbcTemplate") val jdbcTemplate: JdbcTemplate)
                                 (@Autowired @Qualifier("mainSchema") implicit val schemaInfo: SchemaInfo)
  extends RepositoryVersionService with VersionQueries {

  override def storeVersionOfComponent(version: Version): Unit =
    if (PluginVersions.hasTypeFor(version.getComponent, PluginVersions.TYPE_SQL)) {
      if (jdbcTemplate.queryForObject(EXISTS, classOf[Number], version.getComponent).intValue() == 0) {
        jdbcTemplate.update(INSERT, version.getComponent, version.getVersion)
      } else {
        jdbcTemplate.update(UPDATE, version.getVersion, version.getComponent)
      }
    }

  override def readVersionOfComponent(component: String): Version =
    jdbcTemplate.query(SELECT, (rs: ResultSet, row: Int) => {
      Version.valueOf(rs.getString(1), rs.getString(2))
    }, component).asScala.headOption.orNull
}

object VersionSchema {
  val tableName: TableName = TableName("XL_VERSION")

  val component: ColumnName = ColumnName("component")
  val version: ColumnName = ColumnName("version")
}

trait VersionQueries extends Queries {

  import VersionSchema._

  lazy val SELECT = sqlb"select $component, $version from $tableName where $component = ?"
  lazy val INSERT = sqlb"insert into $tableName ($component, $version) values (?, ?)"
  lazy val UPDATE = sqlb"update $tableName set $version = ? where $component = ?"
  lazy val EXISTS = sqlb"select count(*) from $tableName where $component = ?"

}
