package com.xebialabs.deployit.core.upgrade

import com.xebialabs.deployit.core.sql.spring.transactional
import com.xebialabs.deployit.core.sql.{Queries, SchemaInfo, TableName}
import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.transaction.PlatformTransactionManager
import com.xebialabs.deployit.engine.api.ServerService
import com.xebialabs.deployit.engine.api.dto.ServerInfo

import scala.util.Try

class ClearSpringSessionUpgrader
(
  @Autowired @Qualifier("mainSchema") val schemaInfo: SchemaInfo,
  @Autowired @Qualifier("mainJdbcTemplate") val jdbcTemplate: JdbcTemplate,
  @Autowired @Qualifier("mainTransactionManager") transactionManager: PlatformTransactionManager,
  @Autowired serverService: ServerService
) extends Upgrade with Logging with Queries {

  override def doUpgrade(): Boolean = Try({
    transactional(transactionManager) {
      val springSessionTable = TableName("SPRING_SESSION", quoted = false)
      jdbcTemplate.update(sqlb"DELETE FROM $springSessionTable")
    }
  }).isSuccess

  override def upgradeVersion(): Version = Version.valueOf("deployit", getVersion)

  def getVersion: String = {
    val serverInfo: ServerInfo = serverService.getInfo()
    formatVersion(Version.valueOf("deployit", serverInfo.getVersion()))
  }

  def formatVersion(verson: Version) : String = {
    val builder: StringBuilder = new StringBuilder (String.format ("%d.%d.%d", verson.getMajor, verson.getMinor, verson.getMicro))
    builder.toString
  }
}
