package com.xebialabs.deployit.core.upgrade

import com.xebialabs.deployit.core.sql.spring.transactional
import com.xebialabs.deployit.core.sql.{ColumnName, Queries, SchemaInfo, TableName}
import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.transaction.PlatformTransactionManager

import scala.util.Try

class Deployit900RemoveWriteDeletePermissionsUpgrader
(
  @Autowired @Qualifier("mainSchema") val schemaInfo: SchemaInfo,
  @Autowired @Qualifier("mainJdbcTemplate") val jdbcTemplate: JdbcTemplate,
  @Autowired @Qualifier("mainTransactionManager") transactionManager: PlatformTransactionManager
)
  extends Upgrade with Logging with Queries
{
  override def doUpgrade(): Boolean = Try({
    transactional(transactionManager) {
      val rolepermissions = TableName("XL_ROLE_PERMISSIONS")
      val permission = ColumnName("PERMISSION_NAME")
      jdbcTemplate.update(sqlb"DELETE FROM $rolepermissions where $permission = 'write' or $permission = 'delete'")
    }
  }).isSuccess

  override def upgradeVersion(): Version = Version.valueOf("deployit", "9.0.0")
}
