package com.xebialabs.deployit.core.upgrade

import com.xebialabs.deployit.core.upgrade.service.ReferenceIdUpgraderService
import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired

import scala.util.{Failure, Success, Try}

class Deployit1030SetReferenceId(@Autowired val referenceIdUpgraderService: ReferenceIdUpgraderService) extends Upgrade with Logging{
  override def doUpgrade(): Boolean = Try {
      referenceIdUpgraderService.updateReferenceIds()
    } match {
      case Success(_) =>
        logger.debug("Reference_id updates have been successfully applied.")
        true
      case Failure(exception: Exception) =>
        logger.error("Reference_id updates cannot be applied.", exception)
        false
    }

  override def upgradeVersion(): Version = Version.valueOf("deployit", "10.3.0")
}
