/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql.lock;

import com.xebialabs.deployit.core.sql.Queries;
import com.xebialabs.deployit.core.sql.SchemaInfo;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.sql.lock.CiLockQueries;
import com.xebialabs.deployit.repository.sql.lock.CiLockRepository;
import com.xebialabs.deployit.repository.sql.lock.model.CiLock;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.Date;
import java.util.Set;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@Component
@Transactional(value="mainTransactionManager")
@ScalaSignature(bytes="\u0006\u0005\u0005}f\u0001B\b\u0011\u0001uA\u0001b\r\u0001\u0003\u0006\u0004%\t\u0001\u000e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005k!A!\t\u0001BC\u0002\u0013\r1\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003E\u0011\u0015Y\u0005\u0001\"\u0001M\u0011\u00159\u0007\u0001\"\u0011i\u0011\u001d\t9\u0003\u0001C!\u0003SAq!a\u000b\u0001\t\u0003\ni\u0003C\u0004\u00028\u0001!\t%!\u000f\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>!1\u0011\u0003\u0001C\u0005\u0003KBq!!\u001d\u0001\t\u0013\t\u0019\b\u0003\u0004\u0012\u0001\u0011\u0005\u0013Q\u0010\u0005\b\u0003+\u0003A\u0011IAL\u0005Q\u0019\u0015\u000eT8dWJ+\u0007o\\:ji>\u0014\u00180S7qY*\u0011\u0011CE\u0001\u0005Y>\u001c7N\u0003\u0002\u0014)\u0005\u00191/\u001d7\u000b\u0005U1\u0012A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011q\u0003G\u0001\tI\u0016\u0004Hn\\=ji*\u0011\u0011DG\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aG\u0001\u0004G>l7\u0001A\n\u0006\u0001y!\u0003f\u000b\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u00152S\"\u0001\t\n\u0005\u001d\u0002\"\u0001E\"j\u0019>\u001c7NU3q_NLGo\u001c:z!\t)\u0013&\u0003\u0002+!\ti1)\u001b'pG.\fV/\u001a:jKN\u0004\"\u0001L\u0019\u000e\u00035R!AL\u0018\u0002\u000bMdg\r\u000e6\u000b\u0003A\n\u0001b\u001a:jujdW\rZ\u0005\u0003e5\u0012q\u0001T8hO&tw-\u0001\u0007kI\n\u001cG+Z7qY\u0006$X-F\u00016!\t1t(D\u00018\u0015\tA\u0014(\u0001\u0003d_J,'B\u0001\u001e<\u0003\u0011QGMY2\u000b\u0005qj\u0014aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003y\n1a\u001c:h\u0013\t\u0001uG\u0001\u0007KI\n\u001cG+Z7qY\u0006$X-A\u0007kI\n\u001cG+Z7qY\u0006$X\rI\u0001\u000bg\u000eDW-\\1J]\u001a|W#\u0001#\u0011\u0005\u0015CU\"\u0001$\u000b\u0005M9%B\u0001\u001d\u0017\u0013\tIeI\u0001\u0006TG\",W.Y%oM>\f1b]2iK6\f\u0017J\u001c4pA\u00051A(\u001b8jiz\"\"!\u00142\u0015\u00059{\u0005CA\u0013\u0001\u0011\u0015\u0011U\u0001q\u0001EQ\u0011y\u0015k\u0017/\u0011\u0005IKV\"A*\u000b\u0005Q+\u0016AC1o]>$\u0018\r^5p]*\u0011akV\u0001\bM\u0006\u001cGo\u001c:z\u0015\tA6(A\u0003cK\u0006t7/\u0003\u0002['\nI\u0011+^1mS\u001aLWM]\u0001\u0006m\u0006dW/Z\u0011\u0002;\u0006QQ.Y5o'\u000eDW-\\1)\u0005={\u0006C\u0001*a\u0013\t\t7KA\u0005BkR|w/\u001b:fI\")1'\u0002a\u0001k!\"!-U.eC\u0005)\u0017\u0001E7bS:TEMY2UK6\u0004H.\u0019;fQ\t\u0011w,A\tmSN$Hj\\2lg\nKH+Y:l\u0013\u0012$\"![?\u0011\u0007)\u0014XO\u0004\u0002la:\u0011An\\\u0007\u0002[*\u0011a\u000eH\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005J!!\u001d\u0011\u0002\u000fA\f7m[1hK&\u00111\u000f\u001e\u0002\u0005\u0019&\u001cHO\u0003\u0002rAA\u0011aO\u001f\b\u0003ob\u0004\"\u0001\u001c\u0011\n\u0005e\u0004\u0013A\u0002)sK\u0012,g-\u0003\u0002|y\n11\u000b\u001e:j]\u001eT!!\u001f\u0011\t\u000by4\u0001\u0019A@\u0002\rQ\f7o[%e!\u0011\t\t!!\t\u000f\t\u0005\r\u0011Q\u0004\b\u0005\u0003\u000b\t9B\u0004\u0003\u0002\b\u0005Ma\u0002BA\u0005\u0003#qA!a\u0003\u0002\u00109\u0019A.!\u0004\n\u0003mI!!\u0007\u000e\n\u0005]A\u0012bAA\u000b-\u00051QM\\4j]\u0016LA!!\u0007\u0002\u001c\u00051A/Y:lKJT1!!\u0006\u0017\u0013\r\t\u0018q\u0004\u0006\u0005\u00033\tY\"\u0003\u0003\u0002$\u0005\u0015\"A\u0002+bg.LEMC\u0002r\u0003?\tA\u0002\\5ti\u0006cG\u000eT8dWN$\u0012![\u0001\u0013G2,\u0017M\u001d'pG.\u001c()\u001f+bg.LE\r\u0006\u0003\u00020\u0005U\u0002cA\u0010\u00022%\u0019\u00111\u0007\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0006}\"\u0001\r!^\u0001\u000eG2,\u0017M]!mY2{7m[:\u0015\u0005\u0005=\u0012\u0001C4fi2{7m[:\u0015\t\u0005}\u0012Q\n\t\u0005UJ\f\t\u0005\u0005\u0003\u0002D\u0005%SBAA#\u0015\r\t9\u0005E\u0001\u0006[>$W\r\\\u0005\u0005\u0003\u0017\n)E\u0001\u0004DS2{7m\u001b\u0005\b\u0003\u001fR\u0001\u0019AA)\u0003\t\u0019\u0017\u000e\u0005\u0003\u0002T\u0005\u0005TBAA+\u0015\u0011\t9&!\u0017\u0002\u0007U$WN\u0003\u0003\u0002\\\u0005u\u0013aA1qS*\u0019\u0011q\f\f\u0002\rAdWoZ5o\u0013\u0011\t\u0019'!\u0016\u0003#\r{gNZ5hkJ\fG/[8o\u0013R,W\u000e\u0006\u0004\u0002h\u00055\u0014q\u000e\t\u0004?\u0005%\u0014bAA6A\t9!i\\8mK\u0006t\u0007bBA(\u0017\u0001\u0007\u0011\u0011\u000b\u0005\u0006}.\u0001\ra`\u0001\rG\u0006t'+Z3oiJ\fg\u000e\u001e\u000b\t\u0003O\n)(a\u001e\u0002z!9\u0011q\n\u0007A\u0002\u0005E\u0003\"\u0002@\r\u0001\u0004y\bbBA>\u0019\u0001\u0007\u0011qH\u0001\u000bY>\u001c7n\u001d$pe\u000eKGCBA4\u0003\u007f\n\u0019\nC\u0004\u0002\u00026\u0001\r!a!\u0002\u0007\rL7\u000f\u0005\u0004\u0002\u0006\u0006=\u0015\u0011K\u0007\u0003\u0003\u000fSA!!#\u0002\f\u0006!Q\u000f^5m\u0015\t\ti)\u0001\u0003kCZ\f\u0017\u0002BAI\u0003\u000f\u00131aU3u\u0011\u0015qX\u00021\u0001\u0000\u0003\u0019)h\u000e\\8dWR1\u0011qFAM\u00037Cq!!!\u000f\u0001\u0004\t\u0019\tC\u0003\u007f\u001d\u0001\u0007q\u0010\u000b\u0004\u0001\u0003?[\u0016Q\u0016\t\u0005\u0003C\u000bI+\u0004\u0002\u0002$*\u0019A+!*\u000b\u0007\u0005\u001d6(A\u0006ue\u0006t7/Y2uS>t\u0017\u0002BAV\u0003G\u0013Q\u0002\u0016:b]N\f7\r^5p]\u0006d\u0017EAAX\u0003Yi\u0017-\u001b8Ue\u0006t7/Y2uS>tW*\u00198bO\u0016\u0014\bf\u0001\u0001\u00024B!\u0011QWA^\u001b\t\t9LC\u0002\u0002:n\n!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\ti,a.\u0003\u0013\r{W\u000e]8oK:$\b")
public class CiLockRepositoryImpl
implements CiLockRepository,
CiLockQueries,
Logging {
    private final JdbcTemplate jdbcTemplate;
    private final SchemaInfo schemaInfo;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private String LIST_LOCKS_BY_TASK_ID;
    private String LIST_ALL_LOCKS;
    private String CLEAR_LOCKS_WITH_TASK_ID;
    private String CLEAR_ALL_LOCKS;
    private String LOCK;
    private String GET_LOCKS_BY_CI_ID;
    private String UNLOCK;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public Queries.SqlBuilderHelper SqlBuilderHelper(StringContext sc) {
        return Queries.SqlBuilderHelper$((Queries)this, (StringContext)sc);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        CiLockRepositoryImpl ciLockRepositoryImpl = this;
        synchronized (ciLockRepositoryImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public String LIST_LOCKS_BY_TASK_ID() {
        return this.LIST_LOCKS_BY_TASK_ID;
    }

    @Override
    public String LIST_ALL_LOCKS() {
        return this.LIST_ALL_LOCKS;
    }

    @Override
    public String CLEAR_LOCKS_WITH_TASK_ID() {
        return this.CLEAR_LOCKS_WITH_TASK_ID;
    }

    @Override
    public String CLEAR_ALL_LOCKS() {
        return this.CLEAR_ALL_LOCKS;
    }

    @Override
    public String LOCK() {
        return this.LOCK;
    }

    @Override
    public String GET_LOCKS_BY_CI_ID() {
        return this.GET_LOCKS_BY_CI_ID;
    }

    @Override
    public String UNLOCK() {
        return this.UNLOCK;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$lock$CiLockQueries$_setter_$LIST_LOCKS_BY_TASK_ID_$eq(String x$1) {
        this.LIST_LOCKS_BY_TASK_ID = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$lock$CiLockQueries$_setter_$LIST_ALL_LOCKS_$eq(String x$1) {
        this.LIST_ALL_LOCKS = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$lock$CiLockQueries$_setter_$CLEAR_LOCKS_WITH_TASK_ID_$eq(String x$1) {
        this.CLEAR_LOCKS_WITH_TASK_ID = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$lock$CiLockQueries$_setter_$CLEAR_ALL_LOCKS_$eq(String x$1) {
        this.CLEAR_ALL_LOCKS = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$lock$CiLockQueries$_setter_$LOCK_$eq(String x$1) {
        this.LOCK = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$lock$CiLockQueries$_setter_$GET_LOCKS_BY_CI_ID_$eq(String x$1) {
        this.GET_LOCKS_BY_CI_ID = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$lock$CiLockQueries$_setter_$UNLOCK_$eq(String x$1) {
        this.UNLOCK = x$1;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SchemaInfo schemaInfo() {
        return this.schemaInfo;
    }

    @Override
    public List<String> listLocksByTaskId(String taskId) {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate().query(this.LIST_LOCKS_BY_TASK_ID(), (rs, x$1) -> rs.getString(1), new Object[]{taskId})).asScala().toList();
    }

    @Override
    public List<String> listAllLocks() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate().query(this.LIST_ALL_LOCKS(), (rs, x$2) -> rs.getString(1))).asScala().toList();
    }

    @Override
    public void clearLocksByTaskId(String taskId) {
        this.jdbcTemplate().update(this.CLEAR_LOCKS_WITH_TASK_ID(), new Object[]{taskId});
    }

    @Override
    public void clearAllLocks() {
        this.jdbcTemplate().update(this.CLEAR_ALL_LOCKS());
    }

    public List<CiLock> getLocks(ConfigurationItem ci) {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate().query(this.GET_LOCKS_BY_CI_ID(), (RowMapper)new RowMapper<CiLock>(null){

            public CiLock mapRow(ResultSet rs, int rowNum) {
                return new CiLock(rs.getInt(1), rs.getString(2));
            }
        }, new Object[]{ci.get$internalId()})).asScala().toList();
    }

    private boolean lock(ConfigurationItem ci, String taskId) {
        List<CiLock> locksForCi = this.getLocks(ci);
        if (!locksForCi.isEmpty()) {
            return this.canReentrant(ci, taskId, locksForCi);
        }
        int res = this.jdbcTemplate().update(this.LOCK(), new Object[]{ci.get$internalId(), taskId});
        this.logger().info((Function0 & Serializable)() -> new StringBuilder(12).append("Locking ").append(ci.getName()).append(" on ").append(new Date()).toString());
        if (res == 0) {
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(19).append(ci.getName()).append(" already has a lock").toString());
        }
        return res > 0;
    }

    private boolean canReentrant(ConfigurationItem ci, String taskId, List<CiLock> locksForCi) {
        boolean bl;
        if (locksForCi.contains((Object)new CiLock(Predef$.MODULE$.Integer2int(ci.get$internalId()), taskId))) {
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(33).append("Current task ").append(taskId).append(" has already locked ").append(ci.getName()).toString());
            bl = true;
        } else {
            String taskIdWithLock = ((CiLock)locksForCi.find((Function1 & Serializable)ciLock -> BoxesRunTime.boxToBoolean((boolean)CiLockRepositoryImpl.$anonfun$canReentrant$2(ci, ciLock))).get()).taskId();
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(30).append(ci.getName()).append(" is locked by another task  : ").append(taskIdWithLock).toString());
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean lock(Set<ConfigurationItem> cis, String taskId) {
        return CollectionConverters$.MODULE$.SetHasAsScala(cis).asScala().forall((Function1 & Serializable)ci -> BoxesRunTime.boxToBoolean((boolean)this.lock(ci, taskId)));
    }

    @Override
    public void unlock(Set<ConfigurationItem> cis, String taskId) {
        CollectionConverters$.MODULE$.SetHasAsScala(cis).asScala().foreach((Function1 & Serializable)ci -> BoxesRunTime.boxToInteger((int)CiLockRepositoryImpl.$anonfun$unlock$1(this, taskId, ci)));
    }

    public static final /* synthetic */ boolean $anonfun$canReentrant$2(ConfigurationItem ci$2, CiLock ciLock) {
        return BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)ciLock.ciId()), (Object)ci$2.get$internalId());
    }

    public static final /* synthetic */ int $anonfun$unlock$1(CiLockRepositoryImpl $this, String taskId$3, ConfigurationItem ci) {
        return $this.jdbcTemplate().update($this.UNLOCK(), new Object[]{ci.get$internalId(), taskId$3});
    }

    public CiLockRepositoryImpl(@Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired @Qualifier(value="mainSchema") SchemaInfo schemaInfo) {
        this.jdbcTemplate = jdbcTemplate;
        this.schemaInfo = schemaInfo;
        Queries.$init$((Queries)this);
        CiLockQueries.$init$(this);
        Logging.$init$((Logging)this);
        Statics.releaseFence();
    }
}

