package com.xebialabs.deployit.repository.sql.specific.columns

import com.xebialabs.deployit.core.sql.{ColumnName, Queries, SchemaInfo, TableName}
import com.xebialabs.deployit.repository.sql.base.CiPKType
import org.springframework.jdbc.core.JdbcTemplate

class PropertyColumnsDeleter(val table: TableName, val idColumn: ColumnName)
                            (implicit val jdbcTemplate: JdbcTemplate, implicit val schemaInfo: SchemaInfo)
  extends Queries {
  val DELETE = sqlb"delete from $table where $idColumn = ?"
  def delete(pk: CiPKType): Unit = {
    jdbcTemplate.update(DELETE, pk)
  }
}
