package com.xebialabs.deployit.repository

import java.util
import java.util.Collections

import com.xebialabs.deployit.core.sql.toCalendar
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.deployit.repository.HistoryService.CURRENT_REVISION
import com.xebialabs.deployit.repository.sql.{CiHistoryRepository, CiRepository}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.annotation.Primary
import org.springframework.stereotype.Component

@Primary
@Component
class SqlHistoryService(@Autowired ciHistoryRepository: CiHistoryRepository, @Autowired ciRepository: CiRepository) extends HistoryService {

  override def readRevision[T <: ConfigurationItem](id: String, revisionName: String): T =
    ciHistoryRepository.readRevision(id, revisionName)

  override def getVersionRevisions(id: String): util.List[ConfigurationItemRevision] = {
    val revisions = ciHistoryRepository.getVersionRevisions(id)
    if (revisions.isEmpty) {
      val ci: ConfigurationItem = ciRepository.read(id, null, 1)
      Collections.singletonList(ci match {
        case bci: BaseConfigurationItem => new ConfigurationItemRevision(CURRENT_REVISION, toCalendar(bci.get$ciAttributes.getCreatedAt), bci.get$ciAttributes().getCreatedBy)
        case _ => throw new IllegalArgumentException()
      })
    } else {
      revisions
    }
  }
}
