package com.xebialabs.deployit.repository.sql.specific.configurable

import com.xebialabs.deployit.core.sql.ColumnName
import com.xebialabs.deployit.core.sql.batch.BatchCommandWithSetter
import com.xebialabs.deployit.repository.sql.base._
import com.xebialabs.deployit.repository.sql.specific.TypeSpecificInserter
import com.xebialabs.deployit.repository.sql.specific.columns.PropertyColumnsInserter

import scala.collection.mutable

class ConfigurableInserter(val pk: CiPKType, val columns: Option[PropertyColumnsInserter], val tables: Map[String, PropertyTableInserter[_]] = Map())
  extends TypeSpecificInserter {

  val tableValues = new mutable.HashMap[PropertyTableInserter[_], Any]
  val columnValues = new mutable.HashMap[ColumnName, Any]

  override def insertProperty(propertyName: String, value: Any): Boolean = {
    val tableInserter = tables.get(propertyName)
    tableInserter.foreach(tableValues.put(_, value))
    val column = columns.flatMap(_.column(propertyName))
    column.foreach(columnValues.put(_, value))
    tableInserter.isDefined || column.isDefined
  }

  @SuppressWarnings(Array("all")) // Option.get is considered unsafe
  override def finish(handler: PropertyErrorHandler): Unit = {
    columns.foreach(c =>
      handler(c.columns.keys.mkString(", ")) {
        c.setValues(pk, columnValues)
      }
    )
    tableValues.foreach { case (tableInserter, value) =>
      val propertyName = tables.find( _._2 == tableInserter).get._1
      tableInserter.insertProperty(pk, value, handler(propertyName))
    }
  }

  override def batchFinish(): List[BatchCommandWithSetter] = {
    val setValues: Option[BatchCommandWithSetter] = columns.map(c =>
      c.setValuesInBatch(pk, columnValues)
    )
    val inserts = tableValues.flatMap { case (tableInserter, value) =>
      tableInserter.batchInsertProperty(pk, value)
    }

    setValues.map(_ :: inserts.toList).getOrElse(inserts.toList)
  }

}
