/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql.lock;

import com.xebialabs.deployit.core.sql.Queries;
import com.xebialabs.deployit.core.sql.SchemaInfo;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.sql.lock.CiLockQueries;
import com.xebialabs.deployit.repository.sql.lock.CiLockRepository;
import com.xebialabs.deployit.repository.sql.lock.model.CiLock;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.Date;
import java.util.Set;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.StringContext;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@Component
@Transactional(value="mainTransactionManager")
@ScalaSignature(bytes="\u0006\u0005\u0005\rg\u0001B\b\u0011\u0001uA\u0001b\r\u0001\u0003\u0006\u0004%\t\u0001\u000e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005k!A!\t\u0001BC\u0002\u0013\r1\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003E\u0011\u0015Y\u0005\u0001\"\u0001M\u0011\u00159\u0007\u0001\"\u0011i\u0011\u001d\t9\u0003\u0001C!\u0003SAq!a\u000b\u0001\t\u0003\ni\u0003C\u0004\u00028\u0001!\t%!\u000f\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>!1\u0011\u0003\u0001C\u0001\u0003SBq!!\u001e\u0001\t\u0013\t9\b\u0003\u0004\u0012\u0001\u0011\u0005\u0013\u0011\u0011\u0005\b\u00033\u0003A\u0011IAN\u0005Q\u0019\u0015\u000eT8dWJ+\u0007o\\:ji>\u0014\u00180S7qY*\u0011\u0011CE\u0001\u0005Y>\u001c7N\u0003\u0002\u0014)\u0005\u00191/\u001d7\u000b\u0005U1\u0012A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011q\u0003G\u0001\tI\u0016\u0004Hn\\=ji*\u0011\u0011DG\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aG\u0001\u0004G>l7\u0001A\n\u0006\u0001y!\u0003f\u000b\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u00152S\"\u0001\t\n\u0005\u001d\u0002\"\u0001E\"j\u0019>\u001c7NU3q_NLGo\u001c:z!\t)\u0013&\u0003\u0002+!\ti1)\u001b'pG.\fV/\u001a:jKN\u0004\"\u0001L\u0019\u000e\u00035R!AL\u0018\u0002\u000bMdg\r\u000e6\u000b\u0003A\n\u0001b\u001a:jujdW\rZ\u0005\u0003e5\u0012q\u0001T8hO&tw-\u0001\u0007kI\n\u001cG+Z7qY\u0006$X-F\u00016!\t1t(D\u00018\u0015\tA\u0014(\u0001\u0003d_J,'B\u0001\u001e<\u0003\u0011QGMY2\u000b\u0005qj\u0014aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003y\n1a\u001c:h\u0013\t\u0001uG\u0001\u0007KI\n\u001cG+Z7qY\u0006$X-A\u0007kI\n\u001cG+Z7qY\u0006$X\rI\u0001\u000bg\u000eDW-\\1J]\u001a|W#\u0001#\u0011\u0005\u0015CU\"\u0001$\u000b\u0005M9%B\u0001\u001d\u0017\u0013\tIeI\u0001\u0006TG\",W.Y%oM>\f1b]2iK6\f\u0017J\u001c4pA\u00051A(\u001b8jiz\"\"!\u00142\u0015\u00059{\u0005CA\u0013\u0001\u0011\u0015\u0011U\u0001q\u0001EQ\u0011y\u0015k\u0017/\u0011\u0005IKV\"A*\u000b\u0005Q+\u0016AC1o]>$\u0018\r^5p]*\u0011akV\u0001\bM\u0006\u001cGo\u001c:z\u0015\tA6(A\u0003cK\u0006t7/\u0003\u0002['\nI\u0011+^1mS\u001aLWM]\u0001\u0006m\u0006dW/Z\u0011\u0002;\u0006QQ.Y5o'\u000eDW-\\1)\u0005={\u0006C\u0001*a\u0013\t\t7KA\u0005BkR|w/\u001b:fI\")1'\u0002a\u0001k!\"!-U.eC\u0005)\u0017\u0001E7bS:TEMY2UK6\u0004H.\u0019;fQ\t\u0011w,A\tmSN$Hj\\2lg\nKH+Y:l\u0013\u0012$\"![?\u0011\u0007)\u0014XO\u0004\u0002la:\u0011An\\\u0007\u0002[*\u0011a\u000eH\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005J!!\u001d\u0011\u0002\u000fA\f7m[1hK&\u00111\u000f\u001e\u0002\u0005\u0019&\u001cHO\u0003\u0002rAA\u0011aO\u001f\b\u0003ob\u0004\"\u0001\u001c\u0011\n\u0005e\u0004\u0013A\u0002)sK\u0012,g-\u0003\u0002|y\n11\u000b\u001e:j]\u001eT!!\u001f\u0011\t\u000by4\u0001\u0019A@\u0002\rQ\f7o[%e!\u0011\t\t!!\t\u000f\t\u0005\r\u0011Q\u0004\b\u0005\u0003\u000b\t9B\u0004\u0003\u0002\b\u0005Ma\u0002BA\u0005\u0003#qA!a\u0003\u0002\u00109\u0019A.!\u0004\n\u0003mI!!\u0007\u000e\n\u0005]A\u0012bAA\u000b-\u00051QM\\4j]\u0016LA!!\u0007\u0002\u001c\u00051A/Y:lKJT1!!\u0006\u0017\u0013\r\t\u0018q\u0004\u0006\u0005\u00033\tY\"\u0003\u0003\u0002$\u0005\u0015\"A\u0002+bg.LEMC\u0002r\u0003?\tA\u0002\\5ti\u0006cG\u000eT8dWN$\u0012![\u0001\u0013G2,\u0017M\u001d'pG.\u001c()\u001f+bg.LE\r\u0006\u0003\u00020\u0005U\u0002cA\u0010\u00022%\u0019\u00111\u0007\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0006}\"\u0001\r!^\u0001\u000eG2,\u0017M]!mY2{7m[:\u0015\u0005\u0005=\u0012aB4fi2{7m\u001b\u000b\u0005\u0003\u007f\t\t\u0006E\u0003 \u0003\u0003\n)%C\u0002\u0002D\u0001\u0012aa\u00149uS>t\u0007\u0003BA$\u0003\u001bj!!!\u0013\u000b\u0007\u0005-\u0003#A\u0003n_\u0012,G.\u0003\u0003\u0002P\u0005%#AB\"j\u0019>\u001c7\u000eC\u0004\u0002T)\u0001\r!!\u0016\u0002\u0005\rL\u0007\u0003BA,\u0003Kj!!!\u0017\u000b\t\u0005m\u0013QL\u0001\u0004k\u0012l'\u0002BA0\u0003C\n1!\u00199j\u0015\r\t\u0019GF\u0001\u0007a2,x-\u001b8\n\t\u0005\u001d\u0014\u0011\f\u0002\u0012\u0007>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016lGCBA6\u0003c\n\u0019\bE\u0002 \u0003[J1!a\u001c!\u0005\u001d\u0011un\u001c7fC:Dq!a\u0015\f\u0001\u0004\t)\u0006C\u0003\u007f\u0017\u0001\u0007q0\u0001\u0007dC:\u0014V-\u001a8ue\u0006tG\u000f\u0006\u0005\u0002l\u0005e\u00141PA?\u0011\u001d\t\u0019\u0006\u0004a\u0001\u0003+BQA \u0007A\u0002}Dq!a \r\u0001\u0004\t)%\u0001\u0007fq&\u001cH/\u001b8h\u0019>\u001c7\u000e\u0006\u0004\u0002l\u0005\r\u0015q\u0013\u0005\b\u0003\u000bk\u0001\u0019AAD\u0003\r\u0019\u0017n\u001d\t\u0007\u0003\u0013\u000b\u0019*!\u0016\u000e\u0005\u0005-%\u0002BAG\u0003\u001f\u000bA!\u001e;jY*\u0011\u0011\u0011S\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0016\u0006-%aA*fi\")a0\u0004a\u0001\u007f\u00061QO\u001c7pG.$b!a\f\u0002\u001e\u0006}\u0005bBAC\u001d\u0001\u0007\u0011q\u0011\u0005\u0006}:\u0001\ra \u0015\u0007\u0001\u0005\r6,!-\u0011\t\u0005\u0015\u0016QV\u0007\u0003\u0003OS1\u0001VAU\u0015\r\tYkO\u0001\fiJ\fgn]1di&|g.\u0003\u0003\u00020\u0006\u001d&!\u0004+sC:\u001c\u0018m\u0019;j_:\fG.\t\u0002\u00024\u00061R.Y5o)J\fgn]1di&|g.T1oC\u001e,'\u000fK\u0002\u0001\u0003o\u0003B!!/\u0002@6\u0011\u00111\u0018\u0006\u0004\u0003{[\u0014AC:uKJ,w\u000e^=qK&!\u0011\u0011YA^\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class CiLockRepositoryImpl
implements CiLockRepository,
CiLockQueries,
Logging {
    private final JdbcTemplate jdbcTemplate;
    private final SchemaInfo schemaInfo;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private String LIST_LOCKS_BY_TASK_ID;
    private String LIST_ALL_LOCKS;
    private String CLEAR_LOCKS_WITH_TASK_ID;
    private String CLEAR_ALL_LOCKS;
    private String LOCK;
    private String GET_LOCKS_BY_CI_ID;
    private String UNLOCK;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public Queries.SqlBuilderHelper SqlBuilderHelper(StringContext sc) {
        return Queries.SqlBuilderHelper$((Queries)this, (StringContext)sc);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        CiLockRepositoryImpl ciLockRepositoryImpl = this;
        synchronized (ciLockRepositoryImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public String LIST_LOCKS_BY_TASK_ID() {
        return this.LIST_LOCKS_BY_TASK_ID;
    }

    @Override
    public String LIST_ALL_LOCKS() {
        return this.LIST_ALL_LOCKS;
    }

    @Override
    public String CLEAR_LOCKS_WITH_TASK_ID() {
        return this.CLEAR_LOCKS_WITH_TASK_ID;
    }

    @Override
    public String CLEAR_ALL_LOCKS() {
        return this.CLEAR_ALL_LOCKS;
    }

    @Override
    public String LOCK() {
        return this.LOCK;
    }

    @Override
    public String GET_LOCKS_BY_CI_ID() {
        return this.GET_LOCKS_BY_CI_ID;
    }

    @Override
    public String UNLOCK() {
        return this.UNLOCK;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$lock$CiLockQueries$_setter_$LIST_LOCKS_BY_TASK_ID_$eq(String x$1) {
        this.LIST_LOCKS_BY_TASK_ID = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$lock$CiLockQueries$_setter_$LIST_ALL_LOCKS_$eq(String x$1) {
        this.LIST_ALL_LOCKS = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$lock$CiLockQueries$_setter_$CLEAR_LOCKS_WITH_TASK_ID_$eq(String x$1) {
        this.CLEAR_LOCKS_WITH_TASK_ID = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$lock$CiLockQueries$_setter_$CLEAR_ALL_LOCKS_$eq(String x$1) {
        this.CLEAR_ALL_LOCKS = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$lock$CiLockQueries$_setter_$LOCK_$eq(String x$1) {
        this.LOCK = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$lock$CiLockQueries$_setter_$GET_LOCKS_BY_CI_ID_$eq(String x$1) {
        this.GET_LOCKS_BY_CI_ID = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$lock$CiLockQueries$_setter_$UNLOCK_$eq(String x$1) {
        this.UNLOCK = x$1;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SchemaInfo schemaInfo() {
        return this.schemaInfo;
    }

    @Override
    public List<String> listLocksByTaskId(String taskId) {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate().query(this.LIST_LOCKS_BY_TASK_ID(), (rs, x$1) -> rs.getString(1), new Object[]{taskId})).asScala().toList();
    }

    @Override
    public List<String> listAllLocks() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate().query(this.LIST_ALL_LOCKS(), (rs, x$2) -> rs.getString(1))).asScala().toList();
    }

    @Override
    public void clearLocksByTaskId(String taskId) {
        this.jdbcTemplate().update(this.CLEAR_LOCKS_WITH_TASK_ID(), new Object[]{taskId});
    }

    @Override
    public void clearAllLocks() {
        this.jdbcTemplate().update(this.CLEAR_ALL_LOCKS());
    }

    public Option<CiLock> getLock(ConfigurationItem ci) {
        Option option;
        try {
            option = Option$.MODULE$.apply(this.jdbcTemplate().queryForObject(this.GET_LOCKS_BY_CI_ID(), (RowMapper)new RowMapper<CiLock>(null){

                public CiLock mapRow(ResultSet rs, int rowNum) {
                    return new CiLock(rs.getInt(1), rs.getString(2));
                }
            }, new Object[]{ci.get$internalId()}));
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    @Override
    public boolean lock(ConfigurationItem ci, String taskId) {
        boolean bl;
        block7: {
            if (ci.get$internalId() == null) {
                return true;
            }
            Option<CiLock> existingCiLock = this.getLock(ci);
            if (existingCiLock.nonEmpty()) {
                return this.canReentrant(ci, taskId, (CiLock)existingCiLock.get());
            }
            try {
                int res = this.jdbcTemplate().update(this.LOCK(), new Object[]{ci.get$internalId(), taskId});
                this.logger().info((Function0 & Serializable)() -> new StringBuilder(12).append("Locking ").append(ci.getName()).append(" on ").append(new Date()).toString());
                if (res == 0) {
                    this.logger().info((Function0 & Serializable)() -> new StringBuilder(19).append(ci.getName()).append(" already has a lock").toString());
                }
                if (res > 0) {
                    bl = true;
                    break block7;
                }
                bl = false;
            }
            catch (DuplicateKeyException duplicateKeyException) {
                this.logger().warn((Function0 & Serializable)() -> new StringBuilder(28).append(ci.getName()).append(" is locked by another task: ").append(((CiLock)this.getLock(ci).get()).taskId()).toString());
                bl = false;
            }
            catch (Exception e) {
                this.logger().warn((Function0 & Serializable)() -> new StringBuilder(25).append("Failed to lock ").append(ci.getName()).append(" for task ").append(taskId).toString(), (Function0 & Serializable)() -> e);
                bl = false;
            }
        }
        return bl;
    }

    private boolean canReentrant(ConfigurationItem ci, String taskId, CiLock existingLock) {
        if (existingLock.taskId().equals(taskId)) {
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(33).append("Current task ").append(taskId).append(" has already locked ").append(ci.getName()).toString());
            return true;
        }
        this.logger().warn((Function0 & Serializable)() -> new StringBuilder(30).append(ci.getName()).append(" is locked by another task  : ").append(existingLock.taskId()).toString());
        return false;
    }

    @Override
    public boolean lock(Set<ConfigurationItem> cis, String taskId) {
        return CollectionConverters$.MODULE$.SetHasAsScala(cis).asScala().forall((Function1 & Serializable)ci -> BoxesRunTime.boxToBoolean((boolean)this.lock(ci, taskId)));
    }

    @Override
    public void unlock(Set<ConfigurationItem> cis, String taskId) {
        ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(cis).asScala().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CiLockRepositoryImpl.$anonfun$unlock$1(x$3)))).foreach((Function1 & Serializable)ci -> BoxesRunTime.boxToInteger((int)CiLockRepositoryImpl.$anonfun$unlock$2(this, taskId, ci)));
    }

    public static final /* synthetic */ boolean $anonfun$unlock$1(ConfigurationItem x$3) {
        return x$3.get$internalId() != null;
    }

    public static final /* synthetic */ int $anonfun$unlock$2(CiLockRepositoryImpl $this, String taskId$4, ConfigurationItem ci) {
        return $this.jdbcTemplate().update($this.UNLOCK(), new Object[]{ci.get$internalId(), taskId$4});
    }

    public CiLockRepositoryImpl(@Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired @Qualifier(value="mainSchema") SchemaInfo schemaInfo) {
        this.jdbcTemplate = jdbcTemplate;
        this.schemaInfo = schemaInfo;
        Queries.$init$((Queries)this);
        CiLockQueries.$init$(this);
        Logging.$init$((Logging)this);
        Statics.releaseFence();
    }
}

