/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql.commands;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.sql.SchemaInfo;
import com.xebialabs.deployit.core.sql.spring.package;
import com.xebialabs.deployit.engine.spi.event.CiRenamedEvent;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.internal.Root;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactDataRepository;
import com.xebialabs.deployit.repository.sql.base.package$;
import com.xebialabs.deployit.repository.sql.cache.events.CiPathModifiedInfo;
import com.xebialabs.deployit.repository.sql.cache.events.ConsolidatedCiRenamedEvent;
import com.xebialabs.deployit.repository.sql.commands.ChangeSetContext;
import com.xebialabs.deployit.repository.sql.commands.UpdatePathCommand;
import com.xebialabs.deployit.sql.base.schema.CIS$;
import com.xebialabs.deployit.util.Tuple;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001db\u0001\u0002\b\u0010\u0001qA\u0001\"\t\u0001\u0003\u0006\u0004%\tE\t\u0005\t_\u0001\u0011\t\u0011)A\u0005G!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007\u0003\u00058\u0001\t\u0015\r\u0011\"\u00019\u0011!)\u0006A!A!\u0002\u0013I\u0004\u0002\u0003,\u0001\u0005\u000b\u0007I1A,\t\u0011y\u0003!\u0011!Q\u0001\naCQa\u0018\u0001\u0005\u0002\u0001DQa\u001a\u0001\u0005B!DQA\u001d\u0001\u0005BMDQ!\u001e\u0001\u0005\nYDQa\u001f\u0001\u0005\nqDaa \u0001\u0005\n\u0005\u0005!!\u0004*f]\u0006lWmQ8n[\u0006tGM\u0003\u0002\u0011#\u0005A1m\\7nC:$7O\u0003\u0002\u0013'\u0005\u00191/\u001d7\u000b\u0005Q)\u0012A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011acF\u0001\tI\u0016\u0004Hn\\=ji*\u0011\u0001$G\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AG\u0001\u0004G>l7\u0001A\n\u0003\u0001u\u0001\"AH\u0010\u000e\u0003=I!\u0001I\b\u0003#U\u0003H-\u0019;f!\u0006$\bnQ8n[\u0006tG-\u0001\u0007kI\n\u001cG+Z7qY\u0006$X-F\u0001$!\t!S&D\u0001&\u0015\t1s%\u0001\u0003d_J,'B\u0001\u0015*\u0003\u0011QGMY2\u000b\u0005)Z\u0013aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u00031\n1a\u001c:h\u0013\tqSE\u0001\u0007KI\n\u001cG+Z7qY\u0006$X-A\u0007kI\n\u001cG+Z7qY\u0006$X\rI\u0001\u0013CJ$\u0018NZ1diJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00023k5\t1G\u0003\u00025#\u0005I\u0011M\u001d;jM\u0006\u001cGo]\u0005\u0003mM\u0012a#\u0011:uS\u001a\f7\r\u001e#bi\u0006\u0014V\r]8tSR|'/_\u0001\ne\u0016t\u0017-\\3DSN,\u0012!\u000f\t\u0004u\u0011;eBA\u001eB\u001d\tat(D\u0001>\u0015\tq4$\u0001\u0004=e>|GOP\u0005\u0002\u0001\u0006)1oY1mC&\u0011!iQ\u0001\ba\u0006\u001c7.Y4f\u0015\u0005\u0001\u0015BA#G\u0005!IE/\u001a:bE2,'B\u0001\"D!\u0011A5*T'\u000e\u0003%S!AS\u000b\u0002\tU$\u0018\u000e\\\u0005\u0003\u0019&\u0013Q\u0001V;qY\u0016\u0004\"A\u0014*\u000f\u0005=\u0003\u0006C\u0001\u001fD\u0013\t\t6)\u0001\u0004Qe\u0016$WMZ\u0005\u0003'R\u0013aa\u0015;sS:<'BA)D\u0003)\u0011XM\\1nK\u000eK7\u000fI\u0001\u000bg\u000eDW-\\1J]\u001a|W#\u0001-\u0011\u0005ecV\"\u0001.\u000b\u0005IY&B\u0001\u0014\u0016\u0013\ti&L\u0001\u0006TG\",W.Y%oM>\f1b]2iK6\f\u0017J\u001c4pA\u00051A(\u001b8jiz\"B!\u00193fMR\u0011!m\u0019\t\u0003=\u0001AQA\u0016\u0005A\u0004aCQ!\t\u0005A\u0002\rBQ\u0001\r\u0005A\u0002EBQa\u000e\u0005A\u0002e\nq!\u001a=fGV$X\r\u0006\u0002j[B\u0011!n[\u0007\u0002\u0007&\u0011An\u0011\u0002\u0005+:LG\u000fC\u0003o\u0013\u0001\u0007q.A\u0004d_:$X\r\u001f;\u0011\u0005y\u0001\u0018BA9\u0010\u0005A\u0019\u0005.\u00198hKN+GoQ8oi\u0016DH/\u0001\u0005wC2LG-\u0019;f)\tIG\u000fC\u0003o\u0015\u0001\u0007q.\u0001\u0004sK:\fW.\u001a\u000b\u0004S^L\b\"\u0002=\f\u0001\u0004i\u0015!B8mI&#\u0007\"\u0002>\f\u0001\u0004i\u0015a\u00028fo:\u000bW.Z\u0001\u000fm\u0006d\u0017\u000eZ1uKJ+g.Y7f)\rIWP \u0005\u0006q2\u0001\r!\u0014\u0005\u0006u2\u0001\r!T\u0001\u0014cV,'/_!oIB\u0013XMV1mS\u0012\fG/\u001a\u000b\u0007\u0003\u0007\t\u0019#!\n\u0011\r)\f)!TA\u0005\u0013\r\t9a\u0011\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u000f\u0005-\u00111C'\u0002\u00185\u0011\u0011Q\u0002\u0006\u0004\u0015\u0006=!BAA\t\u0003\u0011Q\u0017M^1\n\t\u0005U\u0011Q\u0002\u0002\u0004\u001b\u0006\u0004\b\u0003BA\r\u0003?i!!a\u0007\u000b\t\u0005u\u0011qB\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\"\u0005m!AB(cU\u0016\u001cG\u000fC\u0003y\u001b\u0001\u0007Q\nC\u0003{\u001b\u0001\u0007Q\n")
public class RenameCommand
extends UpdatePathCommand {
    private final JdbcTemplate jdbcTemplate;
    private final Iterable<Tuple<String, String>> renameCis;
    private final SchemaInfo schemaInfo;

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public Iterable<Tuple<String, String>> renameCis() {
        return this.renameCis;
    }

    public SchemaInfo schemaInfo() {
        return this.schemaInfo;
    }

    @Override
    public void execute(ChangeSetContext context) {
        this.renameCis().foreach((Function1 & Serializable)t -> {
            this.rename((String)t.a, (String)t.b);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void validate(ChangeSetContext context) {
        this.renameCis().foreach((Function1 & Serializable)t -> {
            this.validateRename((String)t.a, (String)t.b);
            return BoxedUnit.UNIT;
        });
    }

    private void rename(String oldId, String newName) {
        String string;
        Map map;
        block3: {
            Tuple2<String, Map<String, Object>> tuple2;
            block2: {
                tuple2 = this.queryAndPreValidate(oldId, newName);
                if (tuple2 == null) break block2;
                String oldPath = (String)tuple2._1();
                map = (Map)tuple2._2();
                if (oldPath == null) break block2;
                string = oldPath;
                if (map != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        Map map2 = map;
        Tuple2 tuple2 = new Tuple2((Object)string, (Object)map2);
        Tuple2 tuple22 = tuple2;
        String oldPath = (String)tuple22._1();
        Map map3 = (Map)tuple22._2();
        ConfigurationItem ci = package$.MODULE$.readBaseCiFromMap(map3);
        String newPath = new StringBuilder(1).append((String)package$.MODULE$.parentPath(oldId).getOrElse((Function0 & Serializable)() -> {
            throw new NoSuchElementException(new StringBuilder(22).append("No parent path for ID ").append(oldId).toString());
        })).append("/").append(newName).toString();
        ListBuffer modifiedCisInfo = (ListBuffer)this.updateNameAndPath(oldPath, newPath)._2();
        modifiedCisInfo.addOne((Object)new CiPathModifiedInfo(ci.get$internalId(), package$.MODULE$.pathToId(oldPath), oldPath, ci.getName(), package$.MODULE$.pathToId(newPath), newPath, newName));
        EventBusHolder.publish((Object)new CiRenamedEvent(ci, newName));
        EventBusHolder.publish((Object)new ConsolidatedCiRenamedEvent(ci, (List<CiPathModifiedInfo>)modifiedCisInfo.toList()));
    }

    private void validateRename(String oldId, String newName) {
        this.queryAndPreValidate(oldId, newName);
        String newPath = new StringBuilder(1).append((String)package$.MODULE$.parentPath(oldId).getOrElse((Function0 & Serializable)() -> {
            throw new NoSuchElementException(new StringBuilder(22).append("No parent path for ID ").append(oldId).toString());
        })).append("/").append(newName).toString();
        if (this.exists(newPath)) {
            throw new ItemAlreadyExistsException("The destination id [%s] exists.", new Object[]{package$.MODULE$.pathToId(newPath)});
        }
    }

    private Tuple2<String, Map<String, Object>> queryAndPreValidate(String oldId, String newName) {
        Type ciType;
        Checks.checkArgument((!StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(newName), '/') ? 1 : 0) != 0, (String)"New name [%s] should not contain a /", (Object[])new Object[]{newName});
        String oldPath = package$.MODULE$.idToPath(oldId);
        Map map = (Map)this.jdbcTemplate().queryForObject(this.SELECT_CI_BY_PATH(), (RowMapper)package.MapRowMapper$.MODULE$, new Object[]{oldPath});
        Type type = ciType = Type.valueOf((String)((String)map.get(CIS$.MODULE$.ci_type().name())));
        Type type2 = Type.valueOf(Root.class);
        if (!(type != null ? !type.equals(type2) : type2 != null)) {
            throw new DeployitException("Cannot rename a core.Root configuration item");
        }
        return new Tuple2((Object)oldPath, (Object)map);
    }

    public RenameCommand(JdbcTemplate jdbcTemplate, ArtifactDataRepository artifactRepository, Iterable<Tuple<String, String>> renameCis, SchemaInfo schemaInfo) {
        this.jdbcTemplate = jdbcTemplate;
        this.renameCis = renameCis;
        this.schemaInfo = schemaInfo;
        super(jdbcTemplate, artifactRepository);
    }
}

