package com.xebialabs.deployit.repository.sql.reader

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.repository.sql.base.CiPKType

import scala.collection.mutable

class CiReaderContext {

  val cache: mutable.HashMap[CiPKType, ConfigurationItem] = mutable.HashMap()

}

object CiReaderContext {

  private val CACHE_HOLDER = new ThreadLocal[CiReaderContext]()

  def init(): Unit = CACHE_HOLDER.set(new CiReaderContext)

  def clear(): Unit = CACHE_HOLDER.remove()

  def get: CiReaderContext = Option(CACHE_HOLDER.get).getOrElse(new CiReaderContext)
}
