package com.xebialabs.deployit.repository.sql.cache

import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class CisCacheDataProcessor extends Logging {

  def onUpdate(info: ConsolidatedCiUpdateInfo): Unit = {
    try {
      val cis = info.updatedCisInfos
      logger.trace(s"Clearing Ci data for updated $cis.")
      CiCacheDataServicesHolder
        .getCiCacheDataServiceFacade
        .removeAll(cis.map(ci => ci.pk -> ci.id).toMap)
    } catch {
      case exception: Exception =>
        logger.error("Exception occurred onUpdate cache data process", exception)
    }
  }

  def onDelete(info: ConsolidatedCiDeletedInfo): Unit = {
    try {
      val cis = info.getCis.asScala
      logger.trace(s"Clearing Ci data for deleted (${cis.map(ci => (ci.getId, ci.get$internalId()))}).")
      CiCacheDataServicesHolder
        .getCiCacheDataServiceFacade
        .removeAll(cis.map(ci => ci.get$internalId() -> ci.getId).toMap)
    } catch {
      case exception: Exception =>
        logger.error("Exception occurred onDelete cache data process", exception)
    }
  }

  def onRename(info: ConsolidatedCiRenamedInfo): Unit = {
    try {
      val cis = info.pathModifiedCisInfo
      logger.trace(s"Clearing Ci data for renamed $cis.")
      CiCacheDataServicesHolder
        .getCiCacheDataServiceFacade
        .removeAll(cis.map(ci => ci.pk -> ci.oldId).toMap)
    } catch {
      case exception: Exception =>
        logger.error("Exception occurred onRename cache data process", exception)
    }
  }

  def onMove(info: ConsolidatedCiMovedInfo): Unit = {
    try {
      val cis = info.pathModifiedCisInfo
      logger.trace(s"Clearing Ci data for moved $cis.")
      CiCacheDataServicesHolder
        .getCiCacheDataServiceFacade
        .removeAll(cis.map(ci => ci.pk -> ci.oldId).toMap)
    } catch {
      case exception: Exception =>
        logger.error("Exception occurred onMove cache data process", exception)
    }
  }

}
