package com.xebialabs.deployit.repository.sql.specific.configurable

import com.xebialabs.deployit.core.sql.ColumnName
import com.xebialabs.deployit.core.sql.batch.BatchCommandWithSetter
import com.xebialabs.deployit.repository.sql.base.CiPKType
import com.xebialabs.deployit.repository.sql.reader.properties.CiDataProvider
import com.xebialabs.deployit.repository.sql.specific.TypeSpecificUpdater
import com.xebialabs.deployit.repository.sql.specific.columns.PropertyColumnsUpdater

import scala.collection.mutable

class ConfigurableUpdater(val pk: CiPKType, val columns: Option[PropertyColumnsUpdater], val tables: Map[String, PropertyTableUpdater[_]] = Map())
  extends TypeSpecificUpdater {

  val tableValues = new mutable.HashMap[PropertyTableUpdater[_], Any]
  val columnValues = new mutable.HashMap[ColumnName, Any]

  override def updateProperty(propertyName: String, value: Any): Boolean = {
    val tableUpdater = tables.get(propertyName)
    tableUpdater.foreach(tableValues.put(_, value))
    val column = columns.flatMap(_.column(propertyName))
    column.foreach(columnValues.put(_, value))
    tableUpdater.isDefined || column.isDefined
  }

  override def finish()(implicit ciDataProvider: CiDataProvider): Unit = {
    columns.foreach(_.setValues(pk, columnValues))
    tableValues.foreach{ case (updater, value) => updater.updateProperty(pk, value) }
  }

  override def batchFinish()(implicit ciDataProvider: CiDataProvider): List[BatchCommandWithSetter] = {
    columns.foreach(_.setValues(pk, columnValues))
    tableValues.flatMap{ case (updater, value) => updater.batchUpdateProperty(pk, value) }.toList
  }
}
