package com.xebialabs.deployit.repository.sql.cache

import com.xebialabs.deployit.engine.spi.event.CisDeletedEvent
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind
import com.xebialabs.deployit.repository.sql.base.CiPKType
import org.joda.time.DateTime

import java.{lang, util}
import scala.collection.mutable


case class ConsolidatedCiRenamedInfo(baseModifiedCi: ConfigurationItem,
                                     pathModifiedCisInfo: List[CiPathModifiedInfo]) {
}

case class ConsolidatedCiMovedInfo(baseModifiedCi: ConfigurationItem,
                                   newSecuredCiPk: CiPKType,
                                   newSecuredDirRef: String,
                                   newDirectoryRef: String,
                                   pathModifiedCisInfo: List[CiPathModifiedInfo]) {
}

case class CiPathModifiedInfo(pk: CiPKType,
                              oldId: String,
                              oldPath: String,
                              oldName: String,
                              newId: String,
                              newPath: String,
                              newName: String)

case class ConsolidatedCiUpdateInfo(updatedCisInfos: List[CiUpdateInfo])

case class CiUpdateInfo(token: String,
                        id: String,
                        lastModifiedAt: DateTime,
                        lastModifiedBy: String,
                        scmTraceabilityDataId: Integer,
                        pk: CiPKType,
                        previousToken: String)

case class ConsolidatedCiDeletedInfo(cis: util.List[ConfigurationItem]) extends CisDeletedEvent(cis)

case class CiPropertiesDeleteInfo(pk: CiPKType,
                                  propPks: mutable.Set[lang.Long])

case class CiPropertiesUpdateInfo(pk: CiPKType,
                                  updatedPropertiesInfo: mutable.ListBuffer[UpdatedPropertyInfo])

case class UpdatedPropertyInfo(kind: PropertyKind,
                               newValue: Any,
                               propPk: lang.Long)

case class ConsolidatedCiPropertiesUpdatedInfo(updatedPropertiesInfo: mutable.ListBuffer[CiPropertiesUpdateInfo])
case class ConsolidatedCiPropertiesDeletedInfo(deletedPropertiesCiInfo: mutable.ListBuffer[CiPropertiesDeleteInfo])

