package com.xebialabs.deployit.security.archive.sql.schema

import com.xebialabs.deployit.core.sql.{ColumnName, TableName}

object ArchiveRolesSchema {

  object ArchiveRoles {
    val tableName: TableName = TableName("XLD_ARCHIVE_ROLES")

    val ID: ColumnName = ColumnName("ID")
    val NAME: ColumnName = ColumnName("NAME")
    val CI_ID: ColumnName = ColumnName("CI_ID")
  }

  object ArchiveRoleRoles {
    val tableName: TableName = TableName("XLD_ARCHIVE_ROLE_ROLES")

    val ROLE_ID: ColumnName = ColumnName("ROLE_ID")
    val MEMBER_ROLE_ID: ColumnName = ColumnName("MEMBER_ROLE_ID")
  }

  object ArchiveRolePrincipals {
    val tableName: TableName = TableName("XLD_ARCHIVE_ROLE_PRINCIPALS")

    val ROLE_ID: ColumnName = ColumnName("ROLE_ID")
    val PRINCIPAL_NAME: ColumnName = ColumnName("PRINCIPAL_NAME")
  }
}

object ArchivePermissionsSchema {
  val tableName: TableName = TableName("XLD_ARCHIVE_ROLE_PERMISSIONS")

  val ROLE_ID: ColumnName = ColumnName("ROLE_ID")
  val PERMISSION_NAME: ColumnName = ColumnName("PERMISSION_NAME")
  val CI_ID: ColumnName = ColumnName("CI_ID")
}
