package com.xebialabs.deployit.security.repository

import com.xebialabs.deployit.security.model.XldUserCredentials

trait XldUserCredentialsRepository {
  def findOne(id: Long): Option[XldUserCredentials]
  def findDefaultCredentialsByProfileUsername(username: String): Option[XldUserCredentials]
  def findByProfileUsername(username: String): Set[XldUserCredentials]
  def saveCredentials(xldUserCredentials: XldUserCredentials): Long
  def updateCredentials(xldUserCredentials: XldUserCredentials): Long
  def deleteById(id: Long): Unit
  def deleteByProfileUsername(username: String): Unit
}
