package com.xebialabs.deployit.security.service.impl

import com.xebialabs.deployit.exception.NotFoundException
import com.xebialabs.deployit.security.repository.XldUserDefaultCredentialsRepository
import com.xebialabs.deployit.security.service.UserDefaultCredentialsService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

@Service
class UserDefaultCredentialsServiceImpl(@Autowired repository: XldUserDefaultCredentialsRepository)
  extends UserDefaultCredentialsService{
  override def findDefaultCredentialsId(username: String): Long =
    repository.findDefaultCredentialsId(username)
    .getOrElse(throw new NotFoundException(s"No default user credentials found for user: $username"))


  override def saveOrUpdateDefaultCredentials(username: String, credentialsId: Long): Unit = {
    repository.findDefaultCredentialsId(username) match {
      case Some(_) => repository.updateDefaultCredentials(username, credentialsId)
      case None => repository.saveDefaultCredentials(username, credentialsId)
    }
  }
}
