package com.xebialabs.deployit.security

import ai.digital.deploy.permissions.client.local.logging.PermissionServiceNotImplementedException
import com.xebialabs.deployit.engine.spi.exception.DeployitException
import com.xebialabs.deployit.security.sql.RolesSchema.Roles
import org.springframework.jdbc.core.RowMapper

import java.sql.ResultSet
import java.util
import scala.jdk.CollectionConverters._
import scala.util.{Failure, Success, Try}

package object sql {

  private[sql] def asMutableJavaList[T](list: Iterable[T]): util.List[T] = new util.ArrayList(list.asJavaCollection)

  private[sql] def asMutableJavaMap[K,V](map: Map[K,V]): util.Map[K,V] = new util.HashMap(map.asJava)

  private[sql] def wrapPermissionServiceCall[T](clientCall: () => T): Option[T] =
    Try(clientCall()) match {
      case Success(value) => Option(value)
      case Failure(_: PermissionServiceNotImplementedException) =>
        // ignore
        None
      case Failure(exception) => throw exception
    }

  private[sql] val roleMapper: RowMapper[Role] = (rs: ResultSet, _: Int) =>
    new Role(rs.getString(Roles.ID.name), rs.getString(Roles.NAME.name))

}

final case class MissingPermissionServiceDataException(msg: String) extends DeployitException(msg)
