package com.xebialabs.deployit.security.repository

import com.xebialabs.deployit.security.model.XldUserProfile

import java.util.Date

trait XldUserProfileRepository {
 def findOne(username: String, loadCredentials: Boolean = false): Option[XldUserProfile]
 def createProfile(username: String, analyticsEnabled: Boolean = true): Unit
 def updateProfile(username: String, analyticsEnabled: Boolean): Unit
 def createUserProfile (profile: XldUserProfile): Unit
 def updateUserProfile (profile: XldUserProfile): Unit
 def delete(username: String): Unit
 def countUserWithLoginAllowed(): Int
 def updateLastActive(username: String, date: Date): Int
}
