package com.xebialabs.deployit.security.repository

import com.xebialabs.deployit.engine.api.dto
import com.xebialabs.deployit.engine.api.dto.Paging
import com.xebialabs.deployit.security.model.XldUserProfile

import java.util
import java.util.Date

trait XldUserProfileRepository {
 def findOne(username: String, loadCredentials: Boolean = false): Option[XldUserProfile]
 def createProfile(username: String, analyticsEnabled: Boolean = true): Unit
 def updateProfile(username: String, analyticsEnabled: Boolean): Unit
 def createUserProfile (profile: XldUserProfile): Unit
 def createUserProfile (profile: XldUserProfile, updateLastActive: Boolean): Unit
 def updateUserProfile (profile: XldUserProfile): Unit
 def delete(username: String): Unit
 def countUserWithLoginAllowed(): Int
 def updateLastActive(username: String, date: Date): Int
 def countUsers(username: String, fullName: String, email: String): Long
 def listAllUserProfiles(username: String, fullName: String, email: String, paging: Paging, order: dto.Ordering): util.List[XldUserProfile]
 def updateExternalUserProfile(fullName: String, email: String, lastActive: Date, username: String): Unit
}
