package com.xebialabs.deployit.security.model

import java.util.Date

case class XldUserProfile(username: String, analyticsEnabled: Boolean, credentials: Set[XldUserCredentials], fullName: String ="", email: String="", loginAllowed: Boolean= true, lastActive: Date = null, isInternal: Boolean = true)

object XldUserProfile {
  def apply(username: String,
            analyticsEnabled: Boolean,
            fullName: String,
            email: String,
            loginAllowed: Boolean,
            lastActive: Date,
            isInternal: Boolean): XldUserProfile = XldUserProfile(username, analyticsEnabled, Set.empty[XldUserCredentials], fullName, email, loginAllowed, lastActive, isInternal)
  def apply(username: String,
            analyticsEnabled: Boolean,
            credentials: XldUserCredentials*): XldUserProfile = XldUserProfile(username, analyticsEnabled, credentials.toSet)
}
