package com.xebialabs.deployit.security.model

import java.util.Date

case class XldUserProfile(username: String, analyticsEnabled: Boolean, credentials: Set[XldUserCredentials], fullName: String = null, email: String = null, loginAllowed: Boolean= true, lastActive: Date = null, isInternal: Boolean = true, displayUsername: String = null)

object XldUserProfile {
  def apply(username: String,
            analyticsEnabled: Boolean,
            fullName: String,
            email: String,
            loginAllowed: Boolean,
            lastActive: Date,
            isInternal: Boolean): XldUserProfile = XldUserProfile(username, analyticsEnabled, Set.empty[XldUserCredentials], fullName, email, loginAllowed, lastActive, isInternal)
  def apply(username: String,
            analyticsEnabled: Boolean,
            credentials: XldUserCredentials*): XldUserProfile = XldUserProfile(username, analyticsEnabled, credentials.toSet)

  def apply(username: String,
            analyticsEnabled: Boolean,
            fullName: String,
            email: String,
            loginAllowed: Boolean,
            lastActive: Date,
            isInternal: Boolean,
            displayUsername: String): XldUserProfile = XldUserProfile(username, analyticsEnabled, Set.empty[XldUserCredentials], fullName, email, loginAllowed, lastActive, isInternal, displayUsername)

}
