package com.xebialabs.deployit.security.service

import com.xebialabs.deployit.engine.api.dto
import com.xebialabs.deployit.engine.api.dto.Paging
import com.xebialabs.deployit.security.model.XldUserProfile

import java.util
import java.util.Date

trait UserProfileService {
 def findOne(username: String, loadCredentials: Boolean): XldUserProfile
 def findOne(username: String): XldUserProfile
 def createOrUpdate(username: String, analyticsEnabled: Boolean = true): Unit
 def createOrUpdateUserProfile(xldUserProfile: XldUserProfile): Unit
 def countUserWithLoginAllowed(): Int
 def updateLastActive(username: String, date: Date): Int
 def countUsers(username: String, fullName: String, email: String): Long
 def listAllUserProfiles(username: String, fullName: String, email: String, paging: Paging, order: dto.Ordering): util.List[XldUserProfile]
}
