package com.xebialabs.deployit.security.repository

trait XldUserGroupRepository {

  /**
   * Returns list of groups assigned to the user
   */
  def findGroupsForUser(username: String): Set[String]

  /**
   * Creates a new group with given name
   */
  def createGroup(groupName: String): String

  /**
   * Creates new groups with given name
   */
  def createGroups(groupNames: Set[String]): Set[String]

  /**
   * Deletes a group with given name if exists
   */
  def deleteGroup(groupName: String): Unit

  /**
   * Creates a new group if does not exist and assigns group membership to the supplied user
   */
  def addUserToGroup(username: String, groupName: String): Unit

  /**
   * Removes group membership for the supplied user
   */
  def removeUserFromGroup(username: String, groupName: String): Unit

  /**
   * Removes groups membership for the supplied user
   */
  def removeUserFromGroups(username: String, groupNames: Set[String]): Unit

  /**
   * Assigns or removes group membership for the user based on supplied groupNames
   */
  def updateGroupsMembershipForUser(username: String, groupNames: Set[String]): Unit
}
