/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.sql;

import com.xebialabs.deployit.core.sql.Queries;
import com.xebialabs.deployit.core.sql.SchemaInfo;
import com.xebialabs.deployit.security.repository.XldUserGroupRepository;
import com.xebialabs.deployit.security.sql.Diff;
import com.xebialabs.deployit.security.sql.Group;
import com.xebialabs.deployit.security.sql.SqlXldUserGroupsRepositoryQueries;
import com.xebialabs.deployit.security.sql.XldUserGroupsSchema$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.UUID;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
@Transactional(value="mainTransactionManager")
@ScalaSignature(bytes="\u0006\u0005\u0005Ue\u0001B\t\u0013\u0001uA\u0001B\u000e\u0001\u0003\u0006\u0004%\ta\u000e\u0005\t\t\u0002\u0011\t\u0011)A\u0005q!AQ\t\u0001BC\u0002\u0013\rc\t\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003H\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u0015a\b\u0001\"\u0011~\u0011\u001d\t\t\u0001\u0001C!\u0003\u0007Aq!!\u0003\u0001\t\u0013\tY\u0001C\u0004\u0002\u0016\u0001!\t%a\u0006\t\u000f\u0005\u0005\u0002\u0001\"\u0011\u0002$!9\u0011\u0011\u0006\u0001\u0005\n\u0005-\u0002bBA\u001c\u0001\u0011\u0005\u0013\u0011\b\u0005\b\u0003\u007f\u0001A\u0011IA!\u0011\u001d\t9\u0005\u0001C\u0005\u0003\u0013Bq!a\u0014\u0001\t\u0003\n\tF\u0001\fTc2,6/\u001a:He>,\bOU3q_NLGo\u001c:z\u0015\t\u0019B#A\u0002tc2T!!\u0006\f\u0002\u0011M,7-\u001e:jifT!a\u0006\r\u0002\u0011\u0011,\u0007\u000f\\8zSRT!!\u0007\u000e\u0002\u0013a,'-[1mC\n\u001c(\"A\u000e\u0002\u0007\r|Wn\u0001\u0001\u0014\u000b\u0001qBE\u000b\u0018\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g!\t)\u0003&D\u0001'\u0015\t9C#\u0001\u0006sKB|7/\u001b;pefL!!\u000b\u0014\u0003-acG-V:fe\u001e\u0013x.\u001e9SKB|7/\u001b;pef\u0004\"a\u000b\u0017\u000e\u0003II!!\f\n\u0003CM\u000bH\u000e\u00177e+N,'o\u0012:pkB\u001c(+\u001a9pg&$xN]=Rk\u0016\u0014\u0018.Z:\u0011\u0005=\"T\"\u0001\u0019\u000b\u0005E\u0012\u0014!B:mMRR'\"A\u001a\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\u000e\u0019\u0003\u000f1{wmZ5oO\u0006a!\u000e\u001a2d)\u0016l\u0007\u000f\\1uKV\t\u0001\b\u0005\u0002:\u00056\t!H\u0003\u0002<y\u0005!1m\u001c:f\u0015\tid(\u0001\u0003kI\n\u001c'BA A\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A!\u0002\u0007=\u0014x-\u0003\u0002Du\ta!\n\u001a2d)\u0016l\u0007\u000f\\1uK\u0006i!\u000e\u001a2d)\u0016l\u0007\u000f\\1uK\u0002\n!b]2iK6\f\u0017J\u001c4p+\u00059\u0005C\u0001%L\u001b\u0005I%BA\nK\u0015\tYd#\u0003\u0002M\u0013\nQ1k\u00195f[\u0006LeNZ8\u0002\u0017M\u001c\u0007.Z7b\u0013:4w\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005A+GCA)S!\tY\u0003\u0001C\u0003F\u000b\u0001\u000fq\t\u000b\u0002S)B\u0011Q\u000bX\u0007\u0002-*\u0011q\u000bW\u0001\u000bC:tw\u000e^1uS>t'BA-[\u0003\u001d1\u0017m\u0019;pefT!a\u0017 \u0002\u000b\t,\u0017M\\:\n\u0005u3&!C!vi><\u0018N]3eQ\u0011\u0011vLY2\u0011\u0005U\u0003\u0017BA1W\u0005%\tV/\u00197jM&,'/A\u0003wC2,X-I\u0001e\u0003)i\u0017-\u001b8TG\",W.\u0019\u0005\u0006m\u0015\u0001\r\u0001\u000f\u0015\u0003KRCC!Z0cQ\u0006\n\u0011.\u0001\tnC&t'\n\u001a2d)\u0016l\u0007\u000f\\1uK\u0006\tb-\u001b8e\u000fJ|W\u000f]:G_J,6/\u001a:\u0015\u00051T\bcA7uo:\u0011aN\u001d\t\u0003_\u0002j\u0011\u0001\u001d\u0006\u0003cr\ta\u0001\u0010:p_Rt\u0014BA:!\u0003\u0019\u0001&/\u001a3fM&\u0011QO\u001e\u0002\u0004'\u0016$(BA:!!\ti\u00070\u0003\u0002zm\n11\u000b\u001e:j]\u001eDQa\u001f\u0004A\u0002]\f\u0001\"^:fe:\fW.Z\u0001\fGJ,\u0017\r^3He>,\b\u000f\u0006\u0002x}\")qp\u0002a\u0001o\u0006IqM]8va:\u000bW.Z\u0001\rGJ,\u0017\r^3He>,\bo\u001d\u000b\u0004Y\u0006\u0015\u0001BBA\u0004\u0011\u0001\u0007A.\u0001\u0006he>,\bOT1nKN\f1BZ5oI\u001e\u0013x.\u001e9JIR!\u0011QBA\n!\u0011y\u0012qB<\n\u0007\u0005E\u0001E\u0001\u0004PaRLwN\u001c\u0005\u0006\u007f&\u0001\ra^\u0001\fI\u0016dW\r^3He>,\b\u000f\u0006\u0003\u0002\u001a\u0005}\u0001cA\u0010\u0002\u001c%\u0019\u0011Q\u0004\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u007f*\u0001\ra^\u0001\u000fC\u0012$Wk]3s)><%o\\;q)\u0019\tI\"!\n\u0002(!)1p\u0003a\u0001o\")qp\u0003a\u0001o\u0006Qa-\u001b8e\u000fJ|W\u000f]:\u0015\t\u00055\u0012Q\u0007\t\u0005[R\fy\u0003E\u0002,\u0003cI1!a\r\u0013\u0005\u00159%o\\;q\u0011\u0019\t9\u0001\u0004a\u0001Y\u0006\u0019\"/Z7pm\u0016,6/\u001a:Ge>lwI]8vaR1\u0011\u0011DA\u001e\u0003{AQa_\u0007A\u0002]DQa`\u0007A\u0002]\fAC]3n_Z,Wk]3s\rJ|Wn\u0012:pkB\u001cHCBA\r\u0003\u0007\n)\u0005C\u0003|\u001d\u0001\u0007q\u000f\u0003\u0004\u0002\b9\u0001\r\u0001\\\u0001\u0012iJL\u0018\t\u001a3Vg\u0016\u0014Hk\\$s_V\u0004HCBA\r\u0003\u0017\ni\u0005C\u0003|\u001f\u0001\u0007q\u000fC\u0003\u0000\u001f\u0001\u0007q/A\u000fva\u0012\fG/Z$s_V\u00048/T3nE\u0016\u00148\u000f[5q\r>\u0014Xk]3s)\u0019\tI\"a\u0015\u0002V!)1\u0010\u0005a\u0001o\"1\u0011q\u0001\tA\u00021D3\u0001AA-!\u0011\tY&!\u0019\u000e\u0005\u0005u#bAA0}\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005\r\u0014Q\f\u0002\n\u0007>l\u0007o\u001c8f]RDs\u0001AA4\u0003k\n9\b\u0005\u0003\u0002j\u0005ETBAA6\u0015\r9\u0016Q\u000e\u0006\u0004\u0003_r\u0014aB2p]R,\u0007\u0010^\u0005\u0005\u0003g\nYGA\u0003TG>\u0004X-A\u0005qe>D\u00180T8eK\u0012\u0012\u0011\u0011P\u0005\u0005\u0003w\ni(\u0001\u0007U\u0003J;U\tV0D\u0019\u0006\u001b6K\u0003\u0003\u0002\u0000\u0005-\u0014aD*d_B,G\r\u0015:pqflu\u000eZ3)\r\u0001\t\u0019IYAI!\u0011\t))!$\u000e\u0005\u0005\u001d%bA,\u0002\n*\u0019\u00111\u0012 \u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0003\u001f\u000b9IA\u0007Ue\u0006t7/Y2uS>t\u0017\r\\\u0011\u0003\u0003'\u000ba#\\1j]R\u0013\u0018M\\:bGRLwN\\'b]\u0006<WM\u001d")
public class SqlUserGroupRepository
implements XldUserGroupRepository,
SqlXldUserGroupsRepositoryQueries,
Logging {
    private final JdbcTemplate jdbcTemplate;
    private final SchemaInfo schemaInfo;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private String INSERT;
    private String FIND_GROUP_ID;
    private String FIND_GROUPS;
    private String DELETE_GROUP;
    private String DELETE_USER_GROUP_MEMBERSHIP_BY_GROUP;
    private String INSERT_USER_GROUP_MEMBERSHIP;
    private String DELETE_USER_GROUPS_MEMBERSHIP;
    private String FIND_GROUPS_FOR_USER;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public Queries.SqlBuilderHelper SqlBuilderHelper(StringContext sc) {
        return Queries.SqlBuilderHelper$((Queries)this, (StringContext)sc);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlUserGroupRepository sqlUserGroupRepository = this;
        synchronized (sqlUserGroupRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public String INSERT() {
        return this.INSERT;
    }

    @Override
    public String FIND_GROUP_ID() {
        return this.FIND_GROUP_ID;
    }

    @Override
    public String FIND_GROUPS() {
        return this.FIND_GROUPS;
    }

    @Override
    public String DELETE_GROUP() {
        return this.DELETE_GROUP;
    }

    @Override
    public String DELETE_USER_GROUP_MEMBERSHIP_BY_GROUP() {
        return this.DELETE_USER_GROUP_MEMBERSHIP_BY_GROUP;
    }

    @Override
    public String INSERT_USER_GROUP_MEMBERSHIP() {
        return this.INSERT_USER_GROUP_MEMBERSHIP;
    }

    @Override
    public String DELETE_USER_GROUPS_MEMBERSHIP() {
        return this.DELETE_USER_GROUPS_MEMBERSHIP;
    }

    @Override
    public String FIND_GROUPS_FOR_USER() {
        return this.FIND_GROUPS_FOR_USER;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$SqlXldUserGroupsRepositoryQueries$_setter_$INSERT_$eq(String x$1) {
        this.INSERT = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$SqlXldUserGroupsRepositoryQueries$_setter_$FIND_GROUP_ID_$eq(String x$1) {
        this.FIND_GROUP_ID = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$SqlXldUserGroupsRepositoryQueries$_setter_$FIND_GROUPS_$eq(String x$1) {
        this.FIND_GROUPS = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$SqlXldUserGroupsRepositoryQueries$_setter_$DELETE_GROUP_$eq(String x$1) {
        this.DELETE_GROUP = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$SqlXldUserGroupsRepositoryQueries$_setter_$DELETE_USER_GROUP_MEMBERSHIP_BY_GROUP_$eq(String x$1) {
        this.DELETE_USER_GROUP_MEMBERSHIP_BY_GROUP = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$SqlXldUserGroupsRepositoryQueries$_setter_$INSERT_USER_GROUP_MEMBERSHIP_$eq(String x$1) {
        this.INSERT_USER_GROUP_MEMBERSHIP = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$SqlXldUserGroupsRepositoryQueries$_setter_$DELETE_USER_GROUPS_MEMBERSHIP_$eq(String x$1) {
        this.DELETE_USER_GROUPS_MEMBERSHIP = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$SqlXldUserGroupsRepositoryQueries$_setter_$FIND_GROUPS_FOR_USER_$eq(String x$1) {
        this.FIND_GROUPS_FOR_USER = x$1;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SchemaInfo schemaInfo() {
        return this.schemaInfo;
    }

    @Override
    public Set<String> findGroupsForUser(String username) {
        Set set;
        if (username.isEmpty()) {
            throw new IllegalArgumentException("Group names cannot be empty");
        }
        this.logger().trace((Function0 & Serializable)() -> "Finding groups for user '" + username + "'");
        try {
            List results = this.jdbcTemplate().query(this.FIND_GROUPS_FOR_USER(), (rs, x$1) -> rs.getString(XldUserGroupsSchema$.MODULE$.NAME().name()), new Object[]{username.toLowerCase()});
            set = CollectionConverters$.MODULE$.ListHasAsScala(results).asScala().toSet();
        }
        catch (Exception e) {
            this.logger().error((Function0 & Serializable)() -> "Error finding groups for user '" + username + "'", (Function0 & Serializable)() -> e);
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    @Override
    public String createGroup(String groupName) {
        if (groupName.isEmpty()) {
            throw new IllegalArgumentException("Group names cannot be empty");
        }
        this.logger().trace((Function0 & Serializable)() -> "Creating new group '" + groupName + "'");
        String groupId = UUID.randomUUID().toString();
        this.logger().debug((Function0 & Serializable)() -> "Generated group ID: " + groupId);
        this.jdbcTemplate().update(this.INSERT(), new Object[]{groupId, groupName});
        return groupId;
    }

    @Override
    public Set<String> createGroups(Set<String> groupNames) {
        if (groupNames.isEmpty()) {
            throw new IllegalArgumentException("Group names cannot be empty");
        }
        Set nonEmptyGroupNames = (Set)groupNames.filter((Function1 & Serializable)str -> BoxesRunTime.boxToBoolean((boolean)SqlUserGroupRepository.$anonfun$createGroups$1(str)));
        this.logger().debug((Function0 & Serializable)() -> "Created groups: " + nonEmptyGroupNames.mkString(", "));
        Set groupIds = (Set)((IterableOps)nonEmptyGroupNames.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2.trim()))))).map((Function1 & Serializable)groupName -> {
            String groupId = UUID.randomUUID().toString();
            this.logger().debug((Function0 & Serializable)() -> "Generated group ID for groupName: " + groupName + ": " + groupId);
            return new Tuple2((Object)groupId, groupName);
        });
        groupIds.grouped(100).flatMap((Function1 & Serializable)chunkedGroupIds -> Predef$.MODULE$.wrapIntArray(this.jdbcTemplate().batchUpdate(this.INSERT(), new BatchPreparedStatementSetter(null, (Set)chunkedGroupIds){
            private final Set chunkedGroupIds$1;

            public int getBatchSize() {
                return this.chunkedGroupIds$1.size();
            }

            public void setValues(PreparedStatement ps, int i) {
                ps.setString(1, (String)((Tuple2)this.chunkedGroupIds$1.toSeq().apply(i))._1());
                ps.setString(2, (String)((Tuple2)this.chunkedGroupIds$1.toSeq().apply(i))._2());
            }
            {
                this.chunkedGroupIds$1 = chunkedGroupIds$1;
            }
        })));
        return (Set)groupIds.map((Function1 & Serializable)x$3 -> (String)x$3._1());
    }

    private Option<String> findGroupId(String groupName) {
        None$ none$;
        this.logger().debug((Function0 & Serializable)() -> "Get Group Id for groupName: " + groupName);
        try {
            String groupId = (String)this.jdbcTemplate().queryForObject(this.FIND_GROUP_ID(), String.class, new Object[]{groupName.toLowerCase()});
            none$ = Option$.MODULE$.apply((Object)groupId);
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            none$ = None$.MODULE$;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while retrieving groupid for groupName " + groupName, e);
        }
        return none$;
    }

    @Override
    public void deleteGroup(String groupName) {
        if (groupName.isEmpty() || groupName.trim().isEmpty()) {
            throw new IllegalArgumentException("Group names cannot be empty");
        }
        this.logger().debug((Function0 & Serializable)() -> "Deleting group '" + groupName + "'");
        Option<String> option = this.findGroupId(groupName);
        if (option instanceof Some) {
            Some some = (Some)option;
            String groupId = (String)some.value();
            this.jdbcTemplate().update(this.DELETE_USER_GROUP_MEMBERSHIP_BY_GROUP(), new Object[]{groupId});
            this.jdbcTemplate().update(this.DELETE_GROUP(), new Object[]{groupName.toLowerCase()});
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.logger().trace((Function0 & Serializable)() -> "Group '" + groupName + "' not found");
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public void addUserToGroup(String username, String groupName) {
        String string;
        if (groupName.isEmpty() || username.isEmpty() || groupName.trim().isEmpty() || username.trim().isEmpty()) {
            throw new IllegalArgumentException("Group name/user name cannot be empty");
        }
        this.logger().trace((Function0 & Serializable)() -> "Adding user '" + username + "' to group '" + groupName + "'");
        Option<String> option = this.findGroupId(groupName);
        if (option instanceof Some) {
            String id;
            Some some = (Some)option;
            string = id = (String)some.value();
        } else if (None$.MODULE$.equals(option)) {
            string = this.createGroup(groupName);
        } else {
            throw new MatchError(option);
        }
        String groupId = string;
        this.jdbcTemplate().update(this.INSERT_USER_GROUP_MEMBERSHIP(), new Object[]{groupId, username.toLowerCase()});
    }

    private Set<Group> findGroups(Set<String> groupNames) {
        if (groupNames.isEmpty()) {
            return Predef$.MODULE$.Set().empty();
        }
        return ((IterableOps)groupNames.filter((Function1 & Serializable)str -> BoxesRunTime.boxToBoolean((boolean)SqlUserGroupRepository.$anonfun$findGroups$1(str)))).grouped(100).flatMap((Function1 & Serializable)chunkedGroupNames -> {
            this.logger().debug((Function0 & Serializable)() -> "Finding groups for names: " + chunkedGroupNames.mkString(", "));
            String placeholders = "?" + ", ?".repeat(chunkedGroupNames.size() - 1);
            String sql = this.FIND_GROUPS().replace("(?)", "(" + placeholders + ")");
            List results = this.jdbcTemplate().query(sql, (rs, x$4) -> new Group(rs.getString(XldUserGroupsSchema$.MODULE$.ID().name()), rs.getString(XldUserGroupsSchema$.MODULE$.NAME().name())), (Object[])((IterableOnceOps)chunkedGroupNames.map((Function1 & Serializable)x$5 -> x$5.toLowerCase())).toArray(ClassTag$.MODULE$.apply(String.class)));
            return CollectionConverters$.MODULE$.ListHasAsScala(results).asScala();
        }).toSet();
    }

    @Override
    public void removeUserFromGroup(String username, String groupName) {
        if (groupName.isEmpty() || username.isEmpty() || username.trim().isEmpty() || groupName.trim().isEmpty()) {
            throw new IllegalArgumentException("Group name/user name cannot be empty");
        }
        this.logger().trace((Function0 & Serializable)() -> "Removing user '" + username + "' from group '" + groupName + "'");
        Option<String> option = this.findGroupId(groupName);
        if (option instanceof Some) {
            Some some = (Some)option;
            String groupId = (String)some.value();
            this.jdbcTemplate().update(this.DELETE_USER_GROUPS_MEMBERSHIP(), new Object[]{username.toLowerCase(), groupId});
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.logger().trace((Function0 & Serializable)() -> "Group '" + groupName + "' not found");
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public void removeUserFromGroups(String username, Set<String> groupNames) {
        if (groupNames.isEmpty() || username.isEmpty() || username.trim().isEmpty()) {
            throw new IllegalArgumentException("Group name/user name cannot be empty");
        }
        this.logger().trace((Function0 & Serializable)() -> "Removing user '" + username + "' from groups '" + groupNames + "'");
        Set groupIds = (Set)this.findGroups(groupNames).map((Function1 & Serializable)x$6 -> x$6.id());
        groupIds.grouped(100).foreach((Function1 & Serializable)chunkedGroupIds -> this.jdbcTemplate().batchUpdate(this.DELETE_USER_GROUPS_MEMBERSHIP(), new BatchPreparedStatementSetter(null, (Set)chunkedGroupIds, username){
            private final Set chunkedGroupIds$2;
            private final String username$4;

            public int getBatchSize() {
                return this.chunkedGroupIds$2.size();
            }

            public void setValues(PreparedStatement ps, int i) {
                ps.setString(1, this.username$4.toLowerCase());
                ps.setString(2, (String)this.chunkedGroupIds$2.toSeq().apply(i));
            }
            {
                this.chunkedGroupIds$2 = chunkedGroupIds$2;
                this.username$4 = username$4;
            }
        }));
    }

    private void tryAddUserToGroup(String username, String groupName) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.addUserToGroup(username, groupName));
        if (try_ instanceof Success) {
            this.logger().trace((Function0 & Serializable)() -> "Group " + groupName + " inserted successfully for user " + username);
            return;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable e = failure.exception();
            if (e instanceof DuplicateKeyException) {
                DuplicateKeyException duplicateKeyException = (DuplicateKeyException)e;
                this.logger().trace((Function0 & Serializable)() -> "Group " + groupName + " insertion failed for user " + username + ": " + duplicateKeyException.getMessage());
                return;
            }
        }
        if (bl) {
            Throwable e = failure.exception();
            this.logger().warn((Function0 & Serializable)() -> "Unexpected failure accrued during group " + groupName + " insert for user " + username + ": " + e.getMessage());
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public void updateGroupsMembershipForUser(String username, Set<String> groupNames) {
        Set<String> existingGroupsMembership = this.findGroupsForUser(username);
        Diff<String> diff = new Diff<String>(existingGroupsMembership, groupNames);
        diff.newEntries().foreach((Function1 & Serializable)x$7 -> {
            this.tryAddUserToGroup(username, x$7);
            return BoxedUnit.UNIT;
        });
        diff.deletedEntries().foreach((Function1 & Serializable)x$8 -> {
            this.removeUserFromGroup(username, x$8);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$createGroups$1(String str) {
        return StringUtils.hasText((String)str);
    }

    public static final /* synthetic */ boolean $anonfun$findGroups$1(String str) {
        return StringUtils.hasText((String)str);
    }

    public SqlUserGroupRepository(@Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired @Qualifier(value="mainSchema") SchemaInfo schemaInfo) {
        this.jdbcTemplate = jdbcTemplate;
        this.schemaInfo = schemaInfo;
        Queries.$init$((Queries)this);
        SqlXldUserGroupsRepositoryQueries.$init$(this);
        Logging.$init$((Logging)this);
        Statics.releaseFence();
    }
}

