/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker.repository.sql;

import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import com.xebialabs.deployit.core.sql.Queries;
import com.xebialabs.deployit.core.sql.SchemaInfo;
import com.xebialabs.deployit.core.sql.Selectable;
import com.xebialabs.deployit.core.sql.SimpleSelectBuilder;
import com.xebialabs.deployit.core.sql.SqlCondition;
import com.xebialabs.deployit.core.sql.SqlCondition$;
import com.xebialabs.deployit.core.util.TypeConversions$;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.deployit.engine.tasker.TaskNotFoundException;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.repository.PendingTask;
import com.xebialabs.deployit.engine.tasker.repository.PendingTaskRepository;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTaskMetadataQueries;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTaskMetadataSchema$;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTaskSchema$;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTasksQueries;
import com.xebialabs.deployit.engine.tasker.repository.sql.package$;
import com.xebialabs.deployit.tasksystem.TaskActorSystem$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.altoo.akka.serialization.kryo.KryoAkkaSerializer;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.NoSuchElementException;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@Transactional(value="mainTransactionManager")
@ScalaSignature(bytes="\u0006\u0005\t]e\u0001B\u000f\u001f\u00015B\u0001b\u0012\u0001\u0003\u0006\u0004%\t\u0001\u0013\u0005\t+\u0002\u0011\t\u0011)A\u0005\u0013\"Aa\u000b\u0001BC\u0002\u0013\rq\u000b\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003Y\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u0015Y\b\u0001\"\u0011}\u0011\u001d\t)\u0003\u0001C!\u0003OAq!!\u000b\u0001\t\u0003\nY\u0003C\u0005\u0002h\u0001\t\n\u0011\"\u0001\u0002j!9\u0011Q\u0010\u0001\u0005\n\u0005}\u0004bBAB\u0001\u0011%\u0011Q\u0011\u0005\b\u0003\u0013\u0003A\u0011BAF\u0011\u001d\tY\n\u0001C\u0005\u0003;C\u0011\"a8\u0001#\u0003%I!!\u001b\t\u000f\u0005\u0005\b\u0001\"\u0001\u0002d\"9\u00111\u001f\u0001\u0005B\u0005U\bb\u0002B\u0001\u0001\u0011%!1\u0001\u0005\u000b\u0005\u000f\u0001\u0001R1A\u0005\n\t%\u0001b\u0002B\u0014\u0001\u0011\u0005#\u0011\u0006\u0005\b\u0005c\u0001A\u0011\tB\u001a\u0011\u001d\u00119\u0004\u0001C!\u0005sAqA!\u0011\u0001\t\u0003\u0012\u0019\u0005C\u0004\u0003H\u0001!\tE!\u0013\t\u000f\t]\u0003\u0001\"\u0003\u0003Z!9!Q\f\u0001\u0005\n\t}\u0003b\u0002B2\u0001\u0011%!Q\r\u0005\b\u0005S\u0002A\u0011\u0002B6\u0011\u001d\u0011y\u0007\u0001C\u0005\u0005c\u0012\u0001dU9m!\u0016tG-\u001b8h)\u0006\u001c8NU3q_NLGo\u001c:z\u0015\ty\u0002%A\u0002tc2T!!\t\u0012\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002$I\u00051A/Y:lKJT!!\n\u0014\u0002\r\u0015tw-\u001b8f\u0015\t9\u0003&\u0001\u0005eKBdw._5u\u0015\tI#&A\u0005yK\nL\u0017\r\\1cg*\t1&A\u0002d_6\u001c\u0001a\u0005\u0004\u0001]QBDh\u0010\t\u0003_Ij\u0011\u0001\r\u0006\u0002c\u0005)1oY1mC&\u00111\u0007\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U2T\"\u0001\u0011\n\u0005]\u0002#!\u0006)f]\u0012Lgn\u001a+bg.\u0014V\r]8tSR|'/\u001f\t\u0003sij\u0011AH\u0005\u0003wy\u00111\u0003U3oI&tw\rV1tWN\fV/\u001a:jKN\u0004\"!O\u001f\n\u0005yr\"A\u0007)f]\u0012Lgn\u001a+bg.lU\r^1eCR\f\u0017+^3sS\u0016\u001c\bC\u0001!F\u001b\u0005\t%B\u0001\"D\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005!\u0015\u0001C4sSjTH.\u001a3\n\u0005\u0019\u000b%a\u0002'pO\u001eLgnZ\u0001\rU\u0012\u00147\rV3na2\fG/Z\u000b\u0002\u0013B\u0011!jU\u0007\u0002\u0017*\u0011A*T\u0001\u0005G>\u0014XM\u0003\u0002O\u001f\u0006!!\u000e\u001a2d\u0015\t\u0001\u0016+A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005\u0011\u0016aA8sO&\u0011Ak\u0013\u0002\r\u0015\u0012\u00147\rV3na2\fG/Z\u0001\u000eU\u0012\u00147\rV3na2\fG/\u001a\u0011\u0002\u0015M\u001c\u0007.Z7b\u0013:4w.F\u0001Y!\tIF,D\u0001[\u0015\ty2L\u0003\u0002MM%\u0011QL\u0017\u0002\u000b'\u000eDW-\\1J]\u001a|\u0017aC:dQ\u0016l\u0017-\u00138g_\u0002\na\u0001P5oSRtDCA1w)\t\u00117\r\u0005\u0002:\u0001!)a+\u0002a\u00021\"\"1-Z8q!\t1W.D\u0001h\u0015\tA\u0017.\u0001\u0006b]:|G/\u0019;j_:T!A[6\u0002\u000f\u0019\f7\r^8ss*\u0011AnT\u0001\u0006E\u0016\fgn]\u0005\u0003]\u001e\u0014\u0011\"U;bY&4\u0017.\u001a:\u0002\u000bY\fG.^3\"\u0003E\f!\"\\1j]N\u001b\u0007.Z7bQ\t\u00197\u000f\u0005\u0002gi&\u0011Qo\u001a\u0002\n\u0003V$xn^5sK\u0012DQaR\u0003A\u0002%CCA^3pq\u0006\n\u00110\u0001\tnC&t'\n\u001a2d)\u0016l\u0007\u000f\\1uK\"\u0012ao]\u0001\u0006i\u0006\u001c8n\u001d\u000b\u0004{\u0006m\u0001#\u0002@\u0002\b\u0005-Q\"A@\u000b\t\u0005\u0005\u00111A\u0001\u0005kRLGN\u0003\u0002\u0002\u0006\u0005!!.\u0019<b\u0013\r\tIa \u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\u000e\u0005]QBAA\b\u0015\u0011\t\t\"a\u0005\u0002\u0013\u0015DXmY;uS>t'bAA\u000bI\u0005\u0019\u0011\r]5\n\t\u0005e\u0011q\u0002\u0002\u000e)\u0006\u001c8nV5uQ\ncwnY6\t\u000f\u0005ua\u00011\u0001\u0002 \u0005aAn\\1e\rVdGn\u00159fGB\u0019q&!\t\n\u0007\u0005\r\u0002GA\u0004C_>dW-\u00198\u0002\u001dM\u001c\u0007.\u001a3vY\u0016$G+Y:lgR\tQ0\u0001\u0003uCN\\GCBA\u0017\u0003s\t)\u0007E\u00030\u0003_\t\u0019$C\u0002\u00022A\u0012aa\u00149uS>t\u0007cA\u001b\u00026%\u0019\u0011q\u0007\u0011\u0003\u0017A+g\u000eZ5oOR\u000b7o\u001b\u0005\b\u0003wA\u0001\u0019AA\u001f\u0003\u0019!\u0018m]6JIB!\u0011qHA0\u001d\u0011\t\t%a\u0017\u000f\t\u0005\r\u0013\u0011\f\b\u0005\u0003\u000b\n9F\u0004\u0003\u0002H\u0005Uc\u0002BA%\u0003'rA!a\u0013\u0002R5\u0011\u0011Q\n\u0006\u0004\u0003\u001fb\u0013A\u0002\u001fs_>$h(C\u0001,\u0013\tI#&\u0003\u0002(Q%\u0011QEJ\u0005\u0003G\u0011J1!!\u0018#\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0019\u0002d\t1A+Y:l\u0013\u0012T1!!\u0018#\u0011%\ti\u0002\u0003I\u0001\u0002\u0004\ty\"\u0001\buCN\\G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005-$\u0006BA\u0010\u0003[Z#!a\u001c\u0011\t\u0005E\u0014\u0011P\u0007\u0003\u0003gRA!!\u001e\u0002x\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0003QBJA!a\u001f\u0002t\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0017I,\u0017\rZ*v[6\f'/\u001f\u000b\u0005\u0003[\t\t\tC\u0004\u0002<)\u0001\r!!\u0010\u0002\u0019I,\u0017\r\u001a$vY2\u001c\u0006/Z2\u0015\t\u00055\u0012q\u0011\u0005\b\u0003wY\u0001\u0019AA\u001f\u00035!x\u000eU3oI&tw\rV1tWR!\u00111GAG\u0011\u001d\ty\t\u0004a\u0001\u0003#\u000b!A]:\u0011\t\u0005M\u0015qS\u0007\u0003\u0003+S1aHA\u0002\u0013\u0011\tI*!&\u0003\u0013I+7/\u001e7u'\u0016$\u0018!\u00069f]\u0012Lgn\u001a+bg.4%o\\7CS:\f'/\u001f\u000b\r\u0003g\ty*!-\u0002B\u0006U\u00171\u001c\u0005\b\u0003wi\u0001\u0019AAQ!\u0011\t\u0019+a+\u000f\t\u0005\u0015\u0016q\u0015\t\u0004\u0003\u0017\u0002\u0014bAAUa\u00051\u0001K]3eK\u001aLA!!,\u00020\n11\u000b\u001e:j]\u001eT1!!+1\u0011\u001d\t\u0019,\u0004a\u0001\u0003k\u000bQ\u0002^1tWN\u0003Xm\u0019\"zi\u0016\u001c\b#B\u0018\u00028\u0006m\u0016bAA]a\t)\u0011I\u001d:bsB\u0019q&!0\n\u0007\u0005}\u0006G\u0001\u0003CsR,\u0007bBAb\u001b\u0001\u0007\u0011QY\u0001\u000eg\u000eDW\rZ;mK\u0012$\u0015\r^3\u0011\t\u0005\u001d\u0017\u0011[\u0007\u0003\u0003\u0013TA!a3\u0002N\u0006!A/[7f\u0015\r\ty-U\u0001\u0005U>$\u0017-\u0003\u0003\u0002T\u0006%'\u0001\u0003#bi\u0016$\u0016.\\3\t\u000f\u0005]W\u00021\u0001\u0002Z\u0006iqo\u001c:lKJ\fE\r\u001a:fgN\u0004RaLA\u0018\u0003CC\u0011\"!8\u000e!\u0003\u0005\r!a\b\u0002\u001b%\u001c8+\u001a8u)>\fV/Z;f\u0003}\u0001XM\u001c3j]\u001e$\u0016m]6Ge>l')\u001b8bef$C-\u001a4bk2$H%N\u0001\u0006gR|'/\u001a\u000b\u0007\u0003{\t)/!=\t\u000f\u0005\u001dx\u00021\u0001\u0002j\u0006!1\u000f]3d!\u0011\tY/!<\u000e\u0003\tJ1!a<#\u0005E!\u0016m]6Ta\u0016\u001c\u0017NZ5dCRLwN\u001c\u0005\n\u0003/|\u0001\u0013!a\u0001\u00033\fa!\u001e9eCR,GCBA|\u0003{\fy\u0010E\u00020\u0003sL1!a?1\u0005\u0011)f.\u001b;\t\u000f\u0005m\u0002\u00031\u0001\u0002>!9\u0011q\u001d\tA\u0002\u0005%\u0018\u0001D:qK\u000e$vNQ5oCJLH\u0003BA[\u0005\u000bAq!a:\u0012\u0001\u0004\tI/\u0001\u0006tKJL\u0017\r\\5{KJ,\"Aa\u0003\u0011\t\t5!1E\u0007\u0003\u0005\u001fQAA!\u0005\u0003\u0014\u0005!1N]=p\u0015\u0011\u0011)Ba\u0006\u0002\u001bM,'/[1mSj\fG/[8o\u0015\u0011\u0011IBa\u0007\u0002\t\u0005\\7.\u0019\u0006\u0005\u0005;\u0011y\"A\u0003bYR|wN\u0003\u0002\u0003\"\u0005\u0011\u0011n\\\u0005\u0005\u0005K\u0011yA\u0001\nLef|\u0017i[6b'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018aC2iC:<WmT<oKJ$b!a>\u0003,\t5\u0002bBA\u001e'\u0001\u0007\u0011Q\b\u0005\b\u0005_\u0019\u0002\u0019AAQ\u0003!qWm^(x]\u0016\u0014\u0018!E7be.\f5oU3oiR{\u0017+^3vKR!\u0011q\u001fB\u001b\u0011\u001d\tY\u0004\u0006a\u0001\u0003C\u000b\u0001b]2iK\u0012,H.\u001a\u000b\u0007\u0003o\u0014YD!\u0010\t\u000f\u0005mR\u00031\u0001\u0002>!9!qH\u000bA\u0002\u0005\u0015\u0017\u0001\u00023bi\u0016\fa\u0001Z3mKR,G\u0003BA|\u0005\u000bBq!a\u000f\u0017\u0001\u0004\ti$\u0001\tqe\u0016\u0004\u0018M]3U_\u0016s\u0017/^3vKR!!1\nB+!\u0019\u0011iE!\u0015\u0002\f5\u0011!q\n\u0006\u0004\u0003\u0003\u0001\u0014\u0002\u0002B*\u0005\u001f\u00121\u0001\u0016:z\u0011\u001d\tYd\u0006a\u0001\u0003{\tQ\"\u001a=ue\u0006\u001cG\u000fV1tW&#G\u0003BA\u001f\u00057Bq!a$\u0019\u0001\u0004\t\t*\u0001\u000bfqR\u0014\u0018m\u0019;X_J\\WM]!eIJ,7o\u001d\u000b\u0005\u00033\u0014\t\u0007C\u0004\u0002\u0010f\u0001\r!!%\u0002)\u0015DHO]1diN\u001b\u0007.\u001a3vY\u0016$G)\u0019;f)\u0011\t)Ma\u001a\t\u000f\u0005=%\u00041\u0001\u0002\u0012\u0006AR\r\u001f;sC\u000e$H+Y:l'B,7-\u001b4jG\u0006$\u0018n\u001c8\u0015\t\u0005U&Q\u000e\u0005\b\u0003\u001f[\u0002\u0019AAI\u0003Q)\u0007\u0010\u001e:bGRL5oU3oiR{\u0017+^3vKR!\u0011q\u0004B:\u0011\u001d\ty\t\ba\u0001\u0003#Cc\u0001\u0001B<_\n\u0015\u0005\u0003\u0002B=\u0005\u0003k!Aa\u001f\u000b\u0007!\u0014iHC\u0002\u0003\u0000=\u000b1\u0002\u001e:b]N\f7\r^5p]&!!1\u0011B>\u00055!&/\u00198tC\u000e$\u0018n\u001c8bY\u0006\u0012!qQ\u0001\u0017[\u0006Lg\u000e\u0016:b]N\f7\r^5p]6\u000bg.Y4fe\"\u001a\u0001Aa#\u0011\t\t5%1S\u0007\u0003\u0005\u001fS1A!%P\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0005+\u0013yIA\u0005D_6\u0004xN\\3oi\u0002")
public class SqlPendingTaskRepository
implements PendingTaskRepository,
PendingTasksQueries,
PendingTaskMetadataQueries,
Logging {
    private KryoAkkaSerializer serializer;
    private final JdbcTemplate jdbcTemplate;
    private final SchemaInfo schemaInfo;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private String INSERT_METADATA;
    private String SELECT_METADATA;
    private String DELETE_METADATA;
    private String INSERT;
    private String UPDATE;
    private String UPDATE_OWNER;
    private String SELECT;
    private String SELECT_ALL;
    private String SELECT_ALL_SPECS;
    private String SELECT_SPEC;
    private String DELETE;
    private String UPDATE_SCHEDULED_DATE;
    private String UPDATE_SENT_TO_QUEUE;
    private String SELECT_SCHEDULED;
    private volatile transient boolean bitmap$trans$0;
    private volatile int bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public Queries.SqlBuilderHelper SqlBuilderHelper(StringContext sc) {
        return Queries.SqlBuilderHelper$((Queries)this, (StringContext)sc);
    }

    public Option<String> store$default$2() {
        return PendingTaskRepository.store$default$2$((PendingTaskRepository)this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private String INSERT_METADATA$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 2) == 0) {
                this.INSERT_METADATA = PendingTaskMetadataQueries.INSERT_METADATA$(this);
                this.bitmap$0 |= 2;
            }
        }
        return this.INSERT_METADATA;
    }

    @Override
    public String INSERT_METADATA() {
        return (this.bitmap$0 & 2) == 0 ? this.INSERT_METADATA$lzycompute() : this.INSERT_METADATA;
    }

    private String SELECT_METADATA$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 4) == 0) {
                this.SELECT_METADATA = PendingTaskMetadataQueries.SELECT_METADATA$(this);
                this.bitmap$0 |= 4;
            }
        }
        return this.SELECT_METADATA;
    }

    @Override
    public String SELECT_METADATA() {
        return (this.bitmap$0 & 4) == 0 ? this.SELECT_METADATA$lzycompute() : this.SELECT_METADATA;
    }

    private String DELETE_METADATA$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 8) == 0) {
                this.DELETE_METADATA = PendingTaskMetadataQueries.DELETE_METADATA$(this);
                this.bitmap$0 |= 8;
            }
        }
        return this.DELETE_METADATA;
    }

    @Override
    public String DELETE_METADATA() {
        return (this.bitmap$0 & 8) == 0 ? this.DELETE_METADATA$lzycompute() : this.DELETE_METADATA;
    }

    private String INSERT$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.INSERT = PendingTasksQueries.INSERT$(this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.INSERT;
    }

    @Override
    public String INSERT() {
        return (this.bitmap$0 & 0x10) == 0 ? this.INSERT$lzycompute() : this.INSERT;
    }

    private String UPDATE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.UPDATE = PendingTasksQueries.UPDATE$(this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.UPDATE;
    }

    @Override
    public String UPDATE() {
        return (this.bitmap$0 & 0x20) == 0 ? this.UPDATE$lzycompute() : this.UPDATE;
    }

    private String UPDATE_OWNER$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.UPDATE_OWNER = PendingTasksQueries.UPDATE_OWNER$(this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.UPDATE_OWNER;
    }

    @Override
    public String UPDATE_OWNER() {
        return (this.bitmap$0 & 0x40) == 0 ? this.UPDATE_OWNER$lzycompute() : this.UPDATE_OWNER;
    }

    private String SELECT$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.SELECT = PendingTasksQueries.SELECT$(this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.SELECT;
    }

    @Override
    public String SELECT() {
        return (this.bitmap$0 & 0x80) == 0 ? this.SELECT$lzycompute() : this.SELECT;
    }

    private String SELECT_ALL$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.SELECT_ALL = PendingTasksQueries.SELECT_ALL$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.SELECT_ALL;
    }

    @Override
    public String SELECT_ALL() {
        return (this.bitmap$0 & 0x100) == 0 ? this.SELECT_ALL$lzycompute() : this.SELECT_ALL;
    }

    private String SELECT_ALL_SPECS$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.SELECT_ALL_SPECS = PendingTasksQueries.SELECT_ALL_SPECS$(this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.SELECT_ALL_SPECS;
    }

    @Override
    public String SELECT_ALL_SPECS() {
        return (this.bitmap$0 & 0x200) == 0 ? this.SELECT_ALL_SPECS$lzycompute() : this.SELECT_ALL_SPECS;
    }

    private String SELECT_SPEC$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.SELECT_SPEC = PendingTasksQueries.SELECT_SPEC$(this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.SELECT_SPEC;
    }

    @Override
    public String SELECT_SPEC() {
        return (this.bitmap$0 & 0x400) == 0 ? this.SELECT_SPEC$lzycompute() : this.SELECT_SPEC;
    }

    private String DELETE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.DELETE = PendingTasksQueries.DELETE$(this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.DELETE;
    }

    @Override
    public String DELETE() {
        return (this.bitmap$0 & 0x800) == 0 ? this.DELETE$lzycompute() : this.DELETE;
    }

    private String UPDATE_SCHEDULED_DATE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.UPDATE_SCHEDULED_DATE = PendingTasksQueries.UPDATE_SCHEDULED_DATE$(this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.UPDATE_SCHEDULED_DATE;
    }

    @Override
    public String UPDATE_SCHEDULED_DATE() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.UPDATE_SCHEDULED_DATE$lzycompute() : this.UPDATE_SCHEDULED_DATE;
    }

    private String UPDATE_SENT_TO_QUEUE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.UPDATE_SENT_TO_QUEUE = PendingTasksQueries.UPDATE_SENT_TO_QUEUE$(this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.UPDATE_SENT_TO_QUEUE;
    }

    @Override
    public String UPDATE_SENT_TO_QUEUE() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.UPDATE_SENT_TO_QUEUE$lzycompute() : this.UPDATE_SENT_TO_QUEUE;
    }

    private String SELECT_SCHEDULED$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.SELECT_SCHEDULED = PendingTasksQueries.SELECT_SCHEDULED$(this);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.SELECT_SCHEDULED;
    }

    @Override
    public String SELECT_SCHEDULED() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.SELECT_SCHEDULED$lzycompute() : this.SELECT_SCHEDULED;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SchemaInfo schemaInfo() {
        return this.schemaInfo;
    }

    public java.util.List<TaskWithBlock> tasks(boolean loadFullSpec) {
        List tasks = loadFullSpec ? CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate().query(this.SELECT_ALL_SPECS(), (rs, x$1) -> this.com$xebialabs$deployit$engine$tasker$repository$sql$SqlPendingTaskRepository$$toPendingTask(rs))).asScala().toList() : ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate().queryForList(this.SELECT_ALL())).asScala().groupBy((Function1 & Serializable)x$2 -> (String)x$2.get(PendingTaskSchema$.MODULE$.task_id().name())).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Buffer list = (Buffer)tuple2._2();
            java.util.Map task = (java.util.Map)list.headOption().getOrElse((Function0 & Serializable)() -> {
                throw new NoSuchElementException("No pending task");
            });
            String taskId = (String)task.get(PendingTaskSchema$.MODULE$.task_id().name());
            String taskDescription = (String)task.get(PendingTaskSchema$.MODULE$.task_description().name());
            String owner = (String)task.get(PendingTaskSchema$.MODULE$.task_owner().name());
            String workerAddress = (String)task.get(PendingTaskSchema$.MODULE$.worker_address().name());
            DateTime scheduledDate = (DateTime)Option$.MODULE$.apply(task.get(PendingTaskSchema$.MODULE$.scheduled_date().name())).map((Function1 & Serializable)date -> com.xebialabs.deployit.core.sql.package$.MODULE$.mapDateTime(date)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Boolean isSentToQueue = TypeConversions$.MODULE$.enforceBoolean(task.get(PendingTaskSchema$.MODULE$.is_sent_to_queue().name()));
            java.util.Map metadata = CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)list.map((Function1 & Serializable)item -> {
                String key = (String)item.get(PendingTaskMetadataSchema$.MODULE$.metadata_key().name());
                String value = (String)item.get(PendingTaskMetadataSchema$.MODULE$.metadata_value().name());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
            PendingTask pendingTask = new PendingTask(taskId, taskDescription, owner, metadata, scheduledDate, (Option)None$.MODULE$, Option$.MODULE$.apply((Object)workerAddress), Predef$.MODULE$.Boolean2boolean(isSentToQueue));
            return pendingTask;
        })).toList();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)tasks).asJava();
    }

    public java.util.List<TaskWithBlock> scheduledTasks() {
        return this.jdbcTemplate().query(this.SELECT_SCHEDULED(), (RowMapper)new RowMapper<TaskWithBlock>(this){
            private final /* synthetic */ SqlPendingTaskRepository $outer;

            public TaskWithBlock mapRow(ResultSet rs, int rowNum) {
                return this.$outer.com$xebialabs$deployit$engine$tasker$repository$sql$SqlPendingTaskRepository$$toPendingTask(rs);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Option<PendingTask> task(String taskId, boolean loadFullSpec) {
        return loadFullSpec ? this.readFullSpec(taskId) : this.readSummary(taskId);
    }

    public boolean task$default$2() {
        return false;
    }

    private Option<PendingTask> readSummary(String taskId) {
        None$ none$;
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(30).append("Reading the summary of task [").append(taskId).append("]").toString());
        try {
            none$ = package$.MODULE$.firstOrNone(this.jdbcTemplate().query(this.SELECT(), (rs, x$3) -> {
                String description = rs.getString(PendingTaskSchema$.MODULE$.task_description().name());
                String owner = rs.getString(PendingTaskSchema$.MODULE$.task_owner().name());
                Option<String> workerAddress = this.extractWorkerAddress(rs);
                DateTime scheduledDate = this.extractScheduledDate(rs);
                boolean isSentToQueue = this.extractIsSentToQueue(rs);
                return new Tuple5((Object)description, (Object)owner, (Object)scheduledDate, workerAddress, (Object)BoxesRunTime.boxToBoolean((boolean)isSentToQueue));
            }, new Object[]{taskId})).map((Function1 & Serializable)x0$1 -> {
                Tuple5 tuple5 = x0$1;
                if (tuple5 == null) {
                    throw new MatchError((Object)tuple5);
                }
                String taskDescription = (String)tuple5._1();
                String owner = (String)tuple5._2();
                DateTime scheduledDate = (DateTime)tuple5._3();
                Option workerAddress = (Option)tuple5._4();
                boolean isSendToQueue = BoxesRunTime.unboxToBoolean((Object)tuple5._5());
                HashMap metadata = (HashMap)this.jdbcTemplate().query(this.SELECT_METADATA(), rs -> {
                    void var1_1;
                    HashMap<String, String> map = new HashMap<String, String>();
                    while (rs.next()) {
                        map.put(rs.getString(PendingTaskMetadataSchema$.MODULE$.metadata_key().name()), rs.getString(PendingTaskMetadataSchema$.MODULE$.metadata_value().name()));
                    }
                    return var1_1;
                }, new Object[]{taskId});
                PendingTask pendingTask = new PendingTask(taskId, taskDescription, owner, (java.util.Map)metadata, scheduledDate, (Option)None$.MODULE$, workerAddress, isSendToQueue);
                return pendingTask;
            });
        }
        catch (Exception e) {
            this.logger().error((Function0 & Serializable)() -> e.getMessage(), (Function0 & Serializable)() -> e);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Option<PendingTask> readFullSpec(String taskId) {
        Option option;
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(41).append("Reading the full specification of task [").append(taskId).append("]").toString());
        try {
            option = package$.MODULE$.firstOrNone(this.jdbcTemplate().query(this.SELECT_SPEC(), (rs, x$4) -> this.com$xebialabs$deployit$engine$tasker$repository$sql$SqlPendingTaskRepository$$toPendingTask(rs), new Object[]{taskId}));
        }
        catch (Exception e) {
            this.logger().error((Function0 & Serializable)() -> e.getMessage(), (Function0 & Serializable)() -> e);
            option = None$.MODULE$;
        }
        return option;
    }

    public PendingTask com$xebialabs$deployit$engine$tasker$repository$sql$SqlPendingTaskRepository$$toPendingTask(ResultSet rs) {
        return this.pendingTaskFromBinary(this.extractTaskId(rs), this.extractTaskSpecification(rs), this.extractScheduledDate(rs), this.extractWorkerAddress(rs), this.extractIsSentToQueue(rs));
    }

    private PendingTask pendingTaskFromBinary(String taskId, byte[] taskSpecBytes, DateTime scheduledDate, Option<String> workerAddress, boolean isSentToQueue) {
        Object object = this.serializer().fromBinary(taskSpecBytes);
        if (!(object instanceof TaskSpecification)) {
            throw new RuntimeException(new StringBuilder(42).append("Could not deserialize TaskSpecification [").append(taskId).append("]").toString());
        }
        TaskSpecification taskSpecification = (TaskSpecification)object;
        PendingTask pt = new PendingTask(taskId, taskSpecification.getDescription(), taskSpecification.getOwner().getName(), taskSpecification.getMetadata(), scheduledDate, (Option)new Some((Object)taskSpecification), workerAddress, isSentToQueue);
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(42).append("Pending task from binary has been created ").append(pt).toString());
        PendingTask pendingTask = pt;
        return pendingTask;
    }

    private boolean pendingTaskFromBinary$default$5() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public String store(TaskSpecification spec, Option<String> workerAddress) {
        void var3_3;
        String taskId = spec.getId();
        byte[] bytes = this.specToBinary(spec);
        this.jdbcTemplate().update(this.INSERT(), new Object[]{taskId, spec.getDescription(), spec.getOwner().getName(), bytes, workerAddress.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())});
        spec.getMetadata().forEach((k, v) -> this.jdbcTemplate().update(this.INSERT_METADATA(), new Object[]{taskId, k, v}));
        return var3_3;
    }

    public void update(String taskId, TaskSpecification spec) {
        byte[] bytes = this.specToBinary(spec);
        try {
            this.jdbcTemplate().update(this.UPDATE(), new Object[]{bytes, taskId});
        }
        catch (Exception exception) {
            throw new TaskNotFoundException("pending tasks", taskId);
        }
    }

    private byte[] specToBinary(TaskSpecification spec) {
        byte[] value;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.serializer().toBinary((Object)spec));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                this.logger().error((Function0 & Serializable)() -> exception.getMessage(), (Function0 & Serializable)() -> exception);
                throw exception;
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        byte[] byArray = value = (byte[])success.value();
        return byArray;
    }

    private KryoAkkaSerializer serializer$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 1) == 0) {
                this.serializer = (KryoAkkaSerializer)((Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)((ExtendedActorSystem)TaskActorSystem$.MODULE$.actorSystem()))).serializerFor(Serializable.class);
                this.bitmap$0 |= 1;
            }
        }
        return this.serializer;
    }

    private KryoAkkaSerializer serializer() {
        return (this.bitmap$0 & 1) == 0 ? this.serializer$lzycompute() : this.serializer;
    }

    public void changeOwner(String taskId, String newOwner) {
        this.jdbcTemplate().update(this.UPDATE_OWNER(), new Object[]{newOwner, taskId});
    }

    public void markAsSentToQueue(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(36).append("Marking task [").append(taskId).append("] as sent to the queue").toString());
        this.jdbcTemplate().update(this.UPDATE_SENT_TO_QUEUE(), new Object[]{Boolean.TRUE, taskId});
    }

    public void schedule(String taskId, DateTime date) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(26).append("Task [").append(taskId).append("] has been scheduled").toString());
        this.jdbcTemplate().update(this.UPDATE_SCHEDULED_DATE(), new Object[]{com.xebialabs.deployit.core.sql.package$.MODULE$.toTimestamp(date), taskId});
    }

    public void delete(String taskId) {
        this.jdbcTemplate().update(this.DELETE_METADATA(), new Object[]{taskId});
        this.jdbcTemplate().update(this.DELETE(), new Object[]{taskId});
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(44).append("Pending task ").append(taskId).append(" has been deleted from database").toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Try<TaskWithBlock> prepareToEnqueue(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> "Preparing task [taskId] to enqueue");
        SimpleSelectBuilder q = this.schemaInfo().sqlDialect().lockSelectBuilder(PendingTaskSchema$.MODULE$.tableName(), this.schemaInfo()).select((Selectable)PendingTaskSchema$.MODULE$.task_id()).select((Selectable)PendingTaskSchema$.MODULE$.scheduled_date()).select((Selectable)PendingTaskSchema$.MODULE$.task_specification()).select((Selectable)PendingTaskSchema$.MODULE$.worker_address()).select((Selectable)PendingTaskSchema$.MODULE$.is_sent_to_queue()).where((SqlCondition)SqlCondition$.MODULE$.equals((Selectable)PendingTaskSchema$.MODULE$.task_id(), taskId));
        boolean bl = false;
        Some some = null;
        Option option = package$.MODULE$.firstOrNone(this.jdbcTemplate().query(q.query(), (rs, x$5) -> {
            DateTime scheduledDate = this.extractScheduledDate(rs);
            Option<String> workerAddress = this.extractWorkerAddress(rs);
            return this.pendingTaskFromBinary(this.extractTaskId(rs), this.extractTaskSpecification(rs), scheduledDate, workerAddress, this.extractIsSentToQueue(rs));
        }, new Object[]{taskId}));
        if (None$.MODULE$.equals(option)) {
            return new Failure((Throwable)new RuntimeException(new StringBuilder(21).append("Task [").append(taskId).append("] was not found").toString()));
        }
        if (option instanceof Some) {
            PendingTask pendingTask;
            bl = true;
            some = (Some)option;
            TaskWithBlock task = (TaskWithBlock)some.value();
            if (task instanceof PendingTask && (pendingTask = (PendingTask)task).isSentToQueue()) {
                return new Failure((Throwable)new RuntimeException(new StringBuilder(32).append("Task [").append(taskId).append("] is already sent to queue").toString()));
            }
        }
        if (!bl) throw new MatchError(option);
        TaskWithBlock task = (TaskWithBlock)some.value();
        return new Success((Object)task);
    }

    private String extractTaskId(ResultSet rs) {
        return rs.getString(PendingTaskSchema$.MODULE$.task_id().name());
    }

    private Option<String> extractWorkerAddress(ResultSet rs) {
        return Option$.MODULE$.apply((Object)rs.getString(PendingTaskSchema$.MODULE$.worker_address().name()));
    }

    private DateTime extractScheduledDate(ResultSet rs) {
        return (DateTime)Option$.MODULE$.apply((Object)rs.getTimestamp(PendingTaskSchema$.MODULE$.scheduled_date().name())).map((Function1 & Serializable)t -> com.xebialabs.deployit.core.sql.package$.MODULE$.toDateTime(t)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private byte[] extractTaskSpecification(ResultSet rs) {
        return rs.getBytes(PendingTaskSchema$.MODULE$.task_specification().name());
    }

    private boolean extractIsSentToQueue(ResultSet rs) {
        return rs.getBoolean(PendingTaskSchema$.MODULE$.is_sent_to_queue().name());
    }

    public SqlPendingTaskRepository(@Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired @Qualifier(value="mainSchema") SchemaInfo schemaInfo) {
        this.jdbcTemplate = jdbcTemplate;
        this.schemaInfo = schemaInfo;
        Queries.$init$((Queries)this);
        PendingTasksQueries.$init$(this);
        PendingTaskMetadataQueries.$init$(this);
        Logging.$init$((Logging)this);
    }
}

