package ai.digital.deploy.engine.tasker.service.impl

import ai.digital.deploy.engine.tasker.service.TaskPathStatusService
import com.xebialabs.deployit.engine.api.dto.TaskPathStatus
import com.xebialabs.deployit.engine.tasker.TaskId
import com.xebialabs.deployit.engine.tasker.repository.TaskPathStatusRepository
import com.xebialabs.deployit.exception.NotFoundException
import com.xebialabs.deployit.local.message.MessageService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.dao.{DuplicateKeyException, PessimisticLockingFailureException}
import org.springframework.stereotype.Service

@Service
class TaskPathStatusServiceImpl(@Autowired taskPathStatusRepository: TaskPathStatusRepository,
                                @Autowired deployMessageService: MessageService)
  extends TaskPathStatusService {

  def findOne(taskId: TaskId, path: String): TaskPathStatus =
    taskPathStatusRepository.findOne(taskId, path)
      .getOrElse(throw new NotFoundException(deployMessageService.getMessage("task.status.notfound", taskId, path)))

  def createOrUpdate(taskId: TaskId, path: String, status: String, updateTime: Long): Unit =
    try {
      taskPathStatusRepository.createOrUpdate(taskId, path, status, updateTime)
    } catch {
      case _: PessimisticLockingFailureException | _: DuplicateKeyException =>
        taskPathStatusRepository.createOrUpdate(taskId, path, status, updateTime) // it is ok to retry update because of SERIALIZABLE transaction isolation
      case e =>
        throw e
    }

  def delete(taskId: TaskId): Unit =
    taskPathStatusRepository.delete(taskId)

  def findAll(taskId: TaskId): List[TaskPathStatus] =
    taskPathStatusRepository.findAll(taskId)
}
