package ai.digital.deploy.engine.tasker.service

import com.xebialabs.deployit.engine.api.dto.TaskPathStatus
import com.xebialabs.deployit.engine.tasker.TaskId

trait TaskPathStatusUpdateService {

  def createOrUpdate(taskId: TaskId, path: String, status: String, updateTime: Long): Unit

  def delete(taskId: TaskId): Unit
}

trait TaskPathStatusService extends TaskPathStatusUpdateService {
  def findOne(taskId: TaskId, path: String): TaskPathStatus

  def findAll(taskId: TaskId): List[TaskPathStatus]
}
