package ai.digital.deploy.engine.tasker.service

import com.xebialabs.deployit.core.events.TaskPathStatusEvent
import com.xebialabs.deployit.engine.api.dto.TaskPathStatus
import com.xebialabs.deployit.engine.tasker.TaskId

trait TaskPathStatusUpdateService {

  def batchCreate(taskPathStatuses: Seq[TaskPathStatusEvent], updateTime: Long): Unit

  def create(taskId: TaskId, path: String, status: String, updateTime: Long): Unit

  def delete(taskId: TaskId): Unit

  def updateTaskState(taskId: TaskId, state: String): Unit
}

trait TaskPathStatusService extends TaskPathStatusUpdateService {
  def findOne(taskId: TaskId, path: String): TaskPathStatus
}
