package ai.digital.deploy.task.status.queue

import ai.digital.deploy.pendo.deployment.state.events.PendoDeploymentTaskData
import ai.digital.deploy.task.status.events.PendoDeploymentStateEvent
import com.xebialabs.deployit.core.events.DeploymentStateEvent
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps
import com.xebialabs.deployit.engine.spi.event.SpringInstantiatedListener
import com.xebialabs.xldeploy.jms.adapter.PendoDeploymentStateQueueNameResolver
import grizzled.slf4j.Logging
import nl.javadude.t2bus.Subscribe
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jms.core.JmsTemplate
import org.springframework.scheduling.annotation.Async
import org.springframework.stereotype.Component

import java.util.stream.Collectors
import scala.jdk.CollectionConverters._

@Component
@Autowired
class PendoDeploymentStateProducer(@Qualifier("pendoDeploymentStateJmsTemplate") jmsTemplate: JmsTemplate,
                                   pendoDeploymentStateQueueNameResolver: PendoDeploymentStateQueueNameResolver) extends SpringInstantiatedListener with Logging {

  @Async
  @Subscribe
  def handleDeploymentStateEvent(event: DeploymentStateEvent): Unit = {
    jmsTemplate.convertAndSend(pendoDeploymentStateQueueNameResolver.getPendoDeploymentStateQueueName, new PendoDeploymentStateEvent(event.currentState, getPendoDeploymentTaskData(event.task)))
  }

  private def getPendoDeploymentTaskData(task: TaskWithSteps): PendoDeploymentTaskData = {
    PendoDeploymentTaskData(task.getId, task.getMetadata.asScala.toMap, task.getPackageDependencies.size(), task.getSteps.stream().map(t => t.getMetadata.asScala.toMap).collect(Collectors.toList()).asScala.toList)
  }
}
