/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.config;

import liquibase.configuration.AutoloadedConfigurations;
import liquibase.configuration.ConfigurationDefinition;

public class LiquibaseProConfiguration
implements AutoloadedConfigurations {
    public static final ConfigurationDefinition<String> LICENSE_PRO_LICENSE_KEY;
    public static final ConfigurationDefinition<Boolean> MARK_UNUSED_NOT_DROP;
    public static final ConfigurationDefinition<Boolean> DROP_PUBLIC_SYNONYMS_KEY;
    public static final ConfigurationDefinition<Boolean> INLINE_SQL_KEY;

    static {
        ConfigurationDefinition.Builder builder = new ConfigurationDefinition.Builder("liquibase.pro");
        LICENSE_PRO_LICENSE_KEY = builder.define("licenseKey", String.class).setDescription("Liquibase Pro license key used to unlock paid capabilities. Get a free trial at\n https://www.liquibase.com/protrial and use in CLI or add liquibase.pro.licenseKey=<yourKey> into your defaults file.").setValueObfuscator(string -> {
            if (string == null) {
                return null;
            }
            return "license starting with " + string.substring(0, Math.min(string.length(), 10));
        }).build();
        MARK_UNUSED_NOT_DROP = builder.define("markUnusedNotDrop", Boolean.class).setDescription("If a column would be dropped in a diffChangeLog, call markUnused instead if set to true").setDefaultValue(Boolean.FALSE).build();
        DROP_PUBLIC_SYNONYMS_KEY = builder.define("synonyms.drop.public", Boolean.class).setDescription("If false, do not drop public synonyms in diffChangeLog/dropAll").setDefaultValue(Boolean.TRUE).build();
        INLINE_SQL_KEY = builder.define("sql.inline", Boolean.class).setDescription("If true, generate changeSets with SQL-based changes inlined instead of saving them to an external file").setDefaultValue(Boolean.FALSE).build();
    }
}

