/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.quorum;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.apache.activemq.artemis.quorum.UnavailableStateException;

public interface DistributedLock
extends AutoCloseable {
    public String getLockId();

    public boolean isHeldByCaller() throws UnavailableStateException;

    public boolean tryLock() throws UnavailableStateException, InterruptedException;

    default public boolean tryLock(long timeout, TimeUnit unit) throws UnavailableStateException, InterruptedException {
        long TARGET_FIRE_PERIOD_NS = TimeUnit.MILLISECONDS.toNanos(250L);
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout cannot be negative");
        }
        Objects.requireNonNull(unit);
        if (timeout == 0L) {
            return this.tryLock();
        }
        Thread currentThread = Thread.currentThread();
        long timeoutNs = unit.toNanos(timeout);
        long start = System.nanoTime();
        long deadline = start + timeoutNs;
        long expectedNextFireTime = start;
        while (!currentThread.isInterrupted()) {
            long now;
            long parkNs = expectedNextFireTime - System.nanoTime();
            while (parkNs > 0L) {
                LockSupport.parkNanos(parkNs);
                if (currentThread.isInterrupted()) {
                    throw new InterruptedException();
                }
                now = System.nanoTime();
                parkNs = expectedNextFireTime - now;
            }
            if (this.tryLock()) {
                return true;
            }
            now = System.nanoTime();
            long remainingTime = deadline - now;
            if (remainingTime <= 0L) {
                return false;
            }
            if (remainingTime < TARGET_FIRE_PERIOD_NS) {
                expectedNextFireTime = now;
                continue;
            }
            expectedNextFireTime += TARGET_FIRE_PERIOD_NS;
        }
        throw new InterruptedException();
    }

    public void unlock() throws UnavailableStateException;

    public void addListener(UnavailableLockListener var1);

    public void removeListener(UnavailableLockListener var1);

    @Override
    public void close();

    @FunctionalInterface
    public static interface UnavailableLockListener {
        public void onUnavailableLockEvent();
    }
}

