/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.client;

import akka.Done;
import akka.Done$;
import akka.actor.ActorRefFactory;
import akka.annotation.InternalStableApi;
import akka.event.LoggingAdapter;
import akka.http.impl.engine.client.PoolFlow;
import akka.http.impl.engine.client.PoolId;
import akka.http.impl.engine.client.PoolInterface$;
import akka.http.impl.engine.client.PoolInterface$ShutdownReason$IdleTimeout$;
import akka.http.impl.engine.client.PoolInterface$ShutdownReason$ShutdownRequested$;
import akka.http.impl.engine.client.PoolMaster;
import akka.http.impl.settings.HostConnectionPoolSetup;
import akka.http.impl.util.StreamUtils$;
import akka.http.impl.util.StreamUtils$CaptureTerminationOp$;
import akka.http.impl.util.package$;
import akka.http.impl.util.package$RichHttpRequest$;
import akka.http.javadsl.ConnectionContext;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.HttpResponse$;
import akka.http.scaladsl.model.OptHttpResponse$;
import akka.http.scaladsl.model.ResponseEntity;
import akka.http.scaladsl.model.Uri$;
import akka.http.scaladsl.model.headers.Host;
import akka.http.scaladsl.model.headers.Host$;
import akka.stream.Attributes;
import akka.stream.BufferOverflowException;
import akka.stream.FlowShape;
import akka.stream.Inlet;
import akka.stream.Inlet$;
import akka.stream.Materializer;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.stage.AsyncCallback;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.GraphStageWithMaterializedValue;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.stream.stage.TimerGraphStageLogic;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\rEh\u0001C1c!\u0003\r\n\u0001\u001b7\t\u000bM\u0004a\u0011A;\t\u000f\u0005m\u0001A\"\u0001\u0002\u001e!91Q\u0014\u0001\u0007\u0002\r=x\u0001CA\u0017E\"\u0005\u0001.a\f\u0007\u000f\u0005\u0014\u0007\u0012\u00015\u00022!9\u00111G\u0003\u0005\u0002\u0005UbACA\u001c\u000bA\u0005\u0019\u0013\u00055\u0002:\u001dA\u0011Q\\\u0003\t\u0002!\f\u0019E\u0002\u0005\u00028\u0015A\t\u0001[A \u0011\u001d\t\u0019$\u0003C\u0001\u0003\u0003:q!a\u0012\n\u0011\u0003\u000bIEB\u0004\u0002N%A\t)a\u0014\t\u000f\u0005MB\u0002\"\u0001\u0002r!I\u00111\u000f\u0007\u0002\u0002\u0013\u0005\u0013Q\u000f\u0005\n\u0003\u000fc\u0011\u0011!C\u0001\u0003\u0013C\u0011\"!%\r\u0003\u0003%\t!a%\t\u0013\u0005}E\"!A\u0005B\u0005\u0005\u0006\"CAX\u0019\u0005\u0005I\u0011AAY\u0011%\tY\fDA\u0001\n\u0003\ni\fC\u0005\u0002@2\t\t\u0011\"\u0011\u0002B\"I\u00111\u0019\u0007\u0002\u0002\u0013%\u0011QY\u0004\b\u0003\u001bL\u0001\u0012QAh\r\u001d\ti$\u0003EA\u0003#Dq!a\r\u0018\t\u0003\t\u0019\u000eC\u0005\u0002t]\t\t\u0011\"\u0011\u0002v!I\u0011qQ\f\u0002\u0002\u0013\u0005\u0011\u0011\u0012\u0005\n\u0003#;\u0012\u0011!C\u0001\u0003+D\u0011\"a(\u0018\u0003\u0003%\t%!)\t\u0013\u0005=v#!A\u0005\u0002\u0005e\u0007\"CA^/\u0005\u0005I\u0011IA_\u0011%\tylFA\u0001\n\u0003\n\t\rC\u0005\u0002D^\t\t\u0011\"\u0003\u0002F\"9\u0011q\\\u0003\u0005\u0002\u0005\u0005\b\"CAg\u000b\t\u0007I\u0011BA;\u0011!\u0011Y\"\u0002Q\u0001\n\u0005]dA\u0002B\u000f\u000b\u0001\u0011y\u0002\u0003\u0006\u0002z\u0012\u0012\t\u0011)A\u0005\u0003wD!Ba\u0005%\u0005\u0003\u0005\u000b\u0011\u0002B\u000b\u0011)\u0011Y\u0006\nB\u0001B\u0003%!Q\f\u0005\b\u0003g!C\u0011\u0001B5\u0011%\u0011\u0019\b\nb\u0001\n\u0013\u0011)\b\u0003\u0005\u0003~\u0011\u0002\u000b\u0011\u0002B<\u0011%\u0011y\b\nb\u0001\n\u0013\u0011\t\t\u0003\u0005\u0003\n\u0012\u0002\u000b\u0011\u0002BB\u0011\u001d\u0011Y\t\nC!\u0005\u001bCqAa$%\t\u0003\u0012\t\nC\u0004\u0003\u0010\u0012\"\tE!+\u0007\r\tEV\u0001\u0002BZ\u0011)\tI\u0010\rB\u0001B\u0003%\u00111 \u0005\u000b\u0005\u0017\u0003$\u0011!Q\u0001\n\t5\u0002B\u0003B\na\t\u0005\t\u0015!\u0003\u0003\u0016!Q!1\u000f\u0019\u0003\u0002\u0003\u0006IAa\u001e\t\u0015\t}\u0004G!A!\u0002\u0013\u0011\u0019\t\u0003\u0006\u0003\\A\u0012\t\u0011)A\u0005\u0005;B!Ba21\u0005\u0003\u0005\u000b1\u0002Be\u0011\u001d\t\u0019\u0004\rC\u0001\u0005\u001fD\u0001Ba91A\u0003%!Q\u001d\u0005\n\u0005W\u0004$\u0019!C\u0001\u0005[D\u0001Ba?1A\u0003%!q\u001e\u0005\n\u0005{\u0004$\u0019!C\u0001\u0005\u007fD\u0001b!\u00041A\u0003%1\u0011\u0001\u0005\n\u0007\u001f\u0001$\u0019!C\u0001\u0007#A\u0001b!\u00061A\u0003%11\u0003\u0005\b\u0007/\u0001D\u0011AB\r\u0011%\u0019Y\u0002\ra\u0001\n\u0003\u0019i\u0002C\u0005\u0004&A\u0002\r\u0011\"\u0001\u0004(!A11\u0006\u0019!B\u0013\u0019y\u0002C\u0005\u0004.A\u0002\r\u0011\"\u0001\u0002\n\"I1q\u0006\u0019A\u0002\u0013\u00051\u0011\u0007\u0005\t\u0007k\u0001\u0004\u0015)\u0003\u0002\f\"91q\u0007\u0019\u0005B\re\u0002bBB\u001ea\u0011E3Q\b\u0005\b\u0007\u0007\u0002D\u0011IB\u001d\u0011\u001d\u0019)\u0005\rC!\u0007sA\u0011ba\u00121\u0005\u0004%\ta!\u0013\t\u0011\re\u0003\u0007)A\u0005\u0007\u0017B\u0011ba\u00171\u0005\u0004%\ta!\u0018\t\u0011\r\r\u0004\u0007)A\u0005\u0007?B\u0011b!\u001a1\u0005\u0004%\taa\u001a\t\u0011\r-\u0004\u0007)A\u0005\u0007SBqa!\u001c1\t\u0003\u0019I\u0004C\u0004\u0004pA\"\ta!\u001d\t\u000f\r]\u0004\u0007\"\u0001\u0004:!91\u0011\u0010\u0019\u0005\u0002\re\u0002bBB>a\u0011\u00051\u0011\u0004\u0005\b\u0007{\u0002D\u0011IB@\u0011\u001d\u0019Y\t\rC!\u0007sAaa\u001d\u0019\u0005B\r5\u0005bBA\u000ea\u0011\u000531\u0013\u0005\b\u0007;\u0003D\u0011IBP\u0011\u001d\u0019\t\u000b\rC\u0001\u0007GCqa!.1\t\u0003\u00199\fC\u0004\u0004>B\"\taa0\t\u000f\rU\u0007\u0007\"\u0001\u0004X\"Q1\u0011]\u0003C\u0002\u0013\u0005\u0001na9\t\u0011\r-X\u0001)A\u0005\u0007K\u0014Q\u0002U8pY&sG/\u001a:gC\u000e,'BA2e\u0003\u0019\u0019G.[3oi*\u0011QMZ\u0001\u0007K:<\u0017N\\3\u000b\u0005\u001dD\u0017\u0001B5na2T!!\u001b6\u0002\t!$H\u000f\u001d\u0006\u0002W\u0006!\u0011m[6b'\t\u0001Q\u000e\u0005\u0002oc6\tqNC\u0001q\u0003\u0015\u00198-\u00197b\u0013\t\u0011xN\u0001\u0004B]f\u0014VMZ\u0001\be\u0016\fX/Z:u\u0007\u0001!BA^=\u0002\u0006A\u0011an^\u0005\u0003q>\u0014A!\u00168ji\")1/\u0001a\u0001uB\u001910!\u0001\u000e\u0003qT!! @\u0002\u000b5|G-\u001a7\u000b\u0005}D\u0017\u0001C:dC2\fGm\u001d7\n\u0007\u0005\rAPA\u0006IiR\u0004(+Z9vKN$\bbBA\u0004\u0003\u0001\u0007\u0011\u0011B\u0001\u0010e\u0016\u001c\bo\u001c8tKB\u0013x.\\5tKB1\u00111BA\t\u0003+i!!!\u0004\u000b\u0007\u0005=q.\u0001\u0006d_:\u001cWO\u001d:f]RLA!a\u0005\u0002\u000e\t9\u0001K]8nSN,\u0007cA>\u0002\u0018%\u0019\u0011\u0011\u0004?\u0003\u0019!#H\u000f\u001d*fgB|gn]3\u0002\u0011MDW\u000f\u001e3po:$\"!a\b\u0015\t\u0005\u00052Q\u001e\t\u0007\u0003\u0017\t\u0019#a\n\n\t\u0005\u0015\u0012Q\u0002\u0002\u0007\rV$XO]3\u0011\u0007\u0005%rAD\u0002\u0002,\u0011i\u0011AY\u0001\u000e!>|G.\u00138uKJ4\u0017mY3\u0011\u0007\u0005-Ra\u0005\u0002\u0006[\u00061A(\u001b8jiz\"\"!a\f\u0003\u001dMCW\u000f\u001e3po:\u0014V-Y:p]N\u0011q!\\\u0015\u0004\u000f]a!aC%eY\u0016$\u0016.\\3pkR\u001c\"!C7\u0015\u0005\u0005\r\u0003cAA#\u00135\tQ!A\tTQV$Hm\\<o%\u0016\fX/Z:uK\u0012\u00042!a\u0013\r\u001b\u0005I!!E*ikR$wn\u001e8SKF,Xm\u001d;fINAA\"\\A)\u0003'\nI\u0006E\u0002\u0002F\u001d\u00012A\\A+\u0013\r\t9f\u001c\u0002\b!J|G-^2u!\u0011\tY&a\u001b\u000f\t\u0005u\u0013q\r\b\u0005\u0003?\n)'\u0004\u0002\u0002b)\u0019\u00111\r;\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0018bAA5_\u00069\u0001/Y2lC\u001e,\u0017\u0002BA7\u0003_\u0012AbU3sS\u0006d\u0017N_1cY\u0016T1!!\u001bp)\t\tI%A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003o\u0002B!!\u001f\u0002\u00046\u0011\u00111\u0010\u0006\u0005\u0003{\ny(\u0001\u0003mC:<'BAAA\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u00151\u0010\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005-\u0005c\u00018\u0002\u000e&\u0019\u0011qR8\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005U\u00151\u0014\t\u0004]\u0006]\u0015bAAM_\n\u0019\u0011I\\=\t\u0013\u0005u\u0005#!AA\u0002\u0005-\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002$B1\u0011QUAV\u0003+k!!a*\u000b\u0007\u0005%v.\u0001\u0006d_2dWm\u0019;j_:LA!!,\u0002(\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\u0019,!/\u0011\u00079\f),C\u0002\u00028>\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0002\u001eJ\t\t\u00111\u0001\u0002\u0016\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\f\u0006AAo\\*ue&tw\r\u0006\u0002\u0002x\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011q\u0019\t\u0005\u0003s\nI-\u0003\u0003\u0002L\u0006m$AB(cU\u0016\u001cG/A\u0006JI2,G+[7f_V$\bcAA&/MAq#\\A)\u0003'\nI\u0006\u0006\u0002\u0002PR!\u0011QSAl\u0011%\tijGA\u0001\u0002\u0004\tY\t\u0006\u0003\u00024\u0006m\u0007\"CAO;\u0005\u0005\t\u0019AAK\u00039\u0019\u0006.\u001e;e_^t'+Z1t_:\fQ!\u00199qYf$\u0002\"a9\u0002x\n\u0005!\u0011\u0003\u000b\u0005\u0003K\f9\u000fE\u0002\u0002,\u0001Aq!!;\"\u0001\b\tY/\u0001\u0002g[B!\u0011Q^Az\u001b\t\tyOC\u0002\u0002r*\faa\u001d;sK\u0006l\u0017\u0002BA{\u0003_\u0014A\"T1uKJL\u0017\r\\5{KJDq!!?\"\u0001\u0004\tY0\u0001\u0004q_>d\u0017\n\u001a\t\u0005\u0003W\ti0C\u0002\u0002\u0000\n\u0014a\u0001U8pY&#\u0007b\u0002B\u0002C\u0001\u0007!QA\u0001\u0007a\u0006\u0014XM\u001c;\u0011\t\t\u001d!QB\u0007\u0003\u0005\u0013Q1Aa\u0003k\u0003\u0015\t7\r^8s\u0013\u0011\u0011yA!\u0003\u0003\u001f\u0005\u001bGo\u001c:SK\u001a4\u0015m\u0019;pefDqAa\u0005\"\u0001\u0004\u0011)\"\u0001\u0004nCN$XM\u001d\t\u0005\u0003W\u00119\"C\u0002\u0003\u001a\t\u0014!\u0002U8pY6\u000b7\u000f^3s\u00031IE\r\\3US6,w.\u001e;!\u0005I\u0001vn\u001c7J]R,'OZ1dKN#\u0018mZ3\u0014\u0007\u0011\u0012\t\u0003\u0005\u0005\u0003$\t%\"QFAs\u001b\t\u0011)C\u0003\u0003\u0003(\u0005=\u0018!B:uC\u001e,\u0017\u0002\u0002B\u0016\u0005K\u0011qd\u0012:ba\"\u001cF/Y4f/&$\b.T1uKJL\u0017\r\\5{K\u00124\u0016\r\\;f!!\tiOa\f\u00034\tU\u0013\u0002\u0002B\u0019\u0003_\u0014\u0011B\u00127poNC\u0017\r]3\u0011\t\tU\"q\n\b\u0005\u0005o\u0011YE\u0004\u0003\u0003:\t%c\u0002\u0002B\u001e\u0005\u000frAA!\u0010\u0003F9!!q\bB\"\u001d\u0011\tyF!\u0011\n\u0003-L!!\u001b6\n\u0005\u001dD\u0017BA3g\u0013\t\u0019G-C\u0002\u0003N\t\f\u0001\u0002U8pY\u001acwn^\u0005\u0005\u0005#\u0012\u0019FA\bSKN\u0004xN\\:f\u0007>tG/\u001a=u\u0015\r\u0011iE\u0019\t\u0005\u0005k\u00119&\u0003\u0003\u0003Z\tM#A\u0004*fcV,7\u000f^\"p]R,\u0007\u0010^\u0001\u0004Y><\u0007\u0003\u0002B0\u0005Kj!A!\u0019\u000b\u0007\t\r$.A\u0003fm\u0016tG/\u0003\u0003\u0003h\t\u0005$A\u0004'pO\u001eLgnZ!eCB$XM\u001d\u000b\t\u0005W\u0012iGa\u001c\u0003rA\u0019\u0011Q\t\u0013\t\u000f\u0005e\b\u00061\u0001\u0002|\"9!1\u0003\u0015A\u0002\tU\u0001b\u0002B.Q\u0001\u0007!QL\u0001\u000be\u0016\fX/Z:u\u001fV$XC\u0001B<!\u0019\tiO!\u001f\u0003V%!!1PAx\u0005\u0019yU\u000f\u001e7fi\u0006Y!/Z9vKN$x*\u001e;!\u0003)\u0011Xm\u001d9p]N,\u0017J\\\u000b\u0003\u0005\u0007\u0003b!!<\u0003\u0006\nM\u0012\u0002\u0002BD\u0003_\u0014Q!\u00138mKR\f1B]3ta>t7/Z%oA\u0005)1\u000f[1qKV\u0011!QF\u0001 GJ,\u0017\r^3M_\u001eL7-\u00118e\u001b\u0006$XM]5bY&TX\r\u001a,bYV,G\u0003\u0002BJ\u0005?\u0003rA\u001cBK\u00053\u000b)/C\u0002\u0003\u0018>\u0014a\u0001V;qY\u0016\u0014\u0004\u0003\u0002B\u0012\u00057KAA!(\u0003&\tyqI]1qQN#\u0018mZ3M_\u001eL7\rC\u0004\u0003\":\u0002\rAa)\u0002'%t\u0007.\u001a:ji\u0016$\u0017\t\u001e;sS\n,H/Z:\u0011\t\u00055(QU\u0005\u0005\u0005O\u000byO\u0001\u0006BiR\u0014\u0018NY;uKN$bAa%\u0003,\n5\u0006b\u0002BQ_\u0001\u0007!1\u0015\u0005\b\u0005_{\u0003\u0019AAv\u00035yV.\u0019;fe&\fG.\u001b>fe\n)Aj\\4jGNI\u0001G!.\u0002f\nm&\u0011\u0019\t\u0005\u0005G\u00119,\u0003\u0003\u0003:\n\u0015\"\u0001\u0006+j[\u0016\u0014xI]1qQN#\u0018mZ3M_\u001eL7\r\u0005\u0003\u0003$\tu\u0016\u0002\u0002B`\u0005K\u0011\u0011\"\u00138IC:$G.\u001a:\u0011\t\t\r\"1Y\u0005\u0005\u0005\u000b\u0014)C\u0001\u0006PkRD\u0015M\u001c3mKJ\f\u0001#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0011\t\u0005-!1Z\u0005\u0005\u0005\u001b\fiA\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiRq!\u0011\u001bBl\u00053\u0014YN!8\u0003`\n\u0005H\u0003\u0002Bj\u0005+\u00042!!\u00121\u0011\u001d\u00119\r\u000fa\u0002\u0005\u0013Dq!!?9\u0001\u0004\tY\u0010C\u0004\u0003\fb\u0002\rA!\f\t\u000f\tM\u0001\b1\u0001\u0003\u0016!9!1\u000f\u001dA\u0002\t]\u0004b\u0002B@q\u0001\u0007!1\u0011\u0005\b\u00057B\u0004\u0019\u0001B/\u0003U\u0001vn\u001c7Pm\u0016\u0014h\r\\8x\u000bb\u001cW\r\u001d;j_:\u0004B!!<\u0003h&!!\u0011^Ax\u0005]\u0011UO\u001a4fe>3XM\u001d4m_^,\u0005pY3qi&|g.\u0001\u0003iGB\u001cXC\u0001Bx!\u0011\u0011\tPa>\u000e\u0005\tM(b\u0001B{M\u0006A1/\u001a;uS:<7/\u0003\u0003\u0003z\nM(a\u0006%pgR\u001cuN\u001c8fGRLwN\u001c)p_2\u001cV\r^;q\u0003\u0015A7\r]:!\u0003-IG\r\\3US6,w.\u001e;\u0016\u0005\r\u0005\u0001\u0003BB\u0002\u0007\u0013i!a!\u0002\u000b\t\r\u001d\u0011QB\u0001\tIV\u0014\u0018\r^5p]&!11BB\u0003\u0005!!UO]1uS>t\u0017\u0001D5eY\u0016$\u0016.\\3pkR\u0004\u0013aD:ikR$wn\u001e8Qe>l\u0017n]3\u0016\u0005\rM\u0001CBA\u0006\u0003#\t\t&\u0001\ttQV$Hm\\<o!J|W.[:fA\u0005a1\u000f[;ui&tw\rR8x]V\u0011\u00111W\u0001\u0013g\",H\u000f^5oO\u0012{wO\u001c*fCN|g.\u0006\u0002\u0004 A)an!\t\u0002R%\u001911E8\u0003\r=\u0003H/[8o\u0003Y\u0019\b.\u001e;uS:<Gi\\<o%\u0016\f7o\u001c8`I\u0015\fHc\u0001<\u0004*!I\u0011Q\u0014\"\u0002\u0002\u0003\u00071qD\u0001\u0014g\",H\u000f^5oO\u0012{wO\u001c*fCN|g\u000eI\u0001\u0013e\u0016l\u0017-\u001b8j]\u001e\u0014V-];fgR,G-\u0001\fsK6\f\u0017N\\5oOJ+\u0017/^3ti\u0016$w\fJ3r)\r181\u0007\u0005\n\u0003;+\u0015\u0011!a\u0001\u0003\u0017\u000b1C]3nC&t\u0017N\\4SKF,Xm\u001d;fI\u0002\n\u0001\u0002\u001d:f'R\f'\u000f\u001e\u000b\u0002m\u00069qN\u001c+j[\u0016\u0014Hc\u0001<\u0004@!91\u0011\t%A\u0002\u0005U\u0015\u0001\u0003;j[\u0016\u00148*Z=\u0002\r=t\u0007+^:i\u0003\u0019yg\u000eU;mY\u0006I\"/Z:q_:\u001cXmQ8na2,G/\u001a3DC2d'-Y2l+\t\u0019Y\u0005\u0005\u0004\u0003$\r53\u0011K\u0005\u0005\u0007\u001f\u0012)CA\u0007Bgft7mQ1mY\n\f7m\u001b\t\u0005\u0007'\u001a)&D\u0001k\u0013\r\u00199F\u001b\u0002\u0005\t>tW-\u0001\u000esKN\u0004xN\\:f\u0007>l\u0007\u000f\\3uK\u0012\u001c\u0015\r\u001c7cC\u000e\\\u0007%A\bsKF,Xm\u001d;DC2d'-Y2l+\t\u0019y\u0006\u0005\u0004\u0003$\r53\u0011\r\t\u0007]\nU%0!\u0003\u0002!I,\u0017/^3ti\u000e\u000bG\u000e\u001c2bG.\u0004\u0013\u0001E:ikR$wn\u001e8DC2d'-Y2l+\t\u0019I\u0007E\u0003\u0003$\r5c/A\ttQV$Hm\\<o\u0007\u0006dGNY1dW\u0002\nA#\u00194uKJ\u0014V-];fgR4\u0015N\\5tQ\u0016$\u0017a\u0004:fcV,7\u000f^*ikR$wn\u001e8\u0015\u0007Y\u001c\u0019\bC\u0004\u0004vI\u0003\r!!\u0015\u0002\rI,\u0017m]8o\u0003y\u0019\b.\u001e;e_^t\u0017J\u001a*fcV,7\u000f^3e\u0003:$\u0007k\\:tS\ndW-\u0001\bsKN,G/\u00133mKRKW.\u001a:\u0002!MDw.\u001e7e'R|\u0007o\u00148JI2,\u0017!E8o+B\u001cHO]3b[\u001a\u000b\u0017\u000e\\;sKR\u0019ao!!\t\u000f\r\re\u000b1\u0001\u0004\u0006\u0006\u0011Q\r\u001f\t\u0005\u00037\u001a9)\u0003\u0003\u0004\n\u0006=$!\u0003+ie><\u0018M\u00197f\u0003!\u0001xn\u001d;Ti>\u0004H#\u0002<\u0004\u0010\u000eE\u0005\"B:Y\u0001\u0004Q\bbBA\u00041\u0002\u0007\u0011\u0011\u0002\u000b\u0003\u0007+#Baa&\u0004\u001aB1\u00111BA\u0012\u0003#Bqaa'Z\u0001\b\u0011I-\u0001\u0002fG\u0006aq\u000f[3o'\",H\u000fZ8x]V\u00111qS\u0001\u0007_:Le.\u001b;\u0015\u0007Y\u001c)\u000bC\u0004\u0002zn\u0003\r!a?)\u0007m\u001bI\u000b\u0005\u0003\u0004,\u000eEVBABW\u0015\r\u0019yK[\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BBZ\u0007[\u0013\u0011#\u00138uKJt\u0017\r\\*uC\ndW-\u00119j\u0003)yg\u000eR5ta\u0006$8\r\u001b\u000b\u0004u\u000ee\u0006\"B:]\u0001\u0004Q\bf\u0001/\u0004*\u0006QqN\u001c*fgB|gn]3\u0015\r\u0005U5\u0011YBb\u0011\u0015\u0019X\f1\u0001{\u0011\u001d\u0019)-\u0018a\u0001\u0007\u000f\f\u0001B]3ta>t7/\u001a\t\u0007\u0007\u0013\u001cy-!\u0006\u000e\u0005\r-'bABg_\u0006!Q\u000f^5m\u0013\u0011\u0019\tna3\u0003\u0007Q\u0013\u0018\u0010K\u0002^\u0007S\u000b!c\u001c8SKN\u0004xN\\:f\u0007>l\u0007\u000f\\3uKR\u0019ao!7\t\u000f\rmg\f1\u0001\u0002\u0016\u0006\u0019\u0011M\\=)\u0007y\u001bI\u000bK\u00021\u0007S\u000bQ\u0002U8pY2{wmU8ve\u000e,WCABs!\u0019\u0011yfa:\u0002|&!1\u0011\u001eB1\u0005%aunZ*pkJ\u001cW-\u0001\bQ_>dGj\\4T_V\u00148-\u001a\u0011\t\u000f\rm%\u0001q\u0001\u0003JV\u0011\u0011\u0011\u0005")
public interface PoolInterface {
    public static PoolInterface apply(PoolId poolId, ActorRefFactory parent, PoolMaster master, Materializer fm) {
        return PoolInterface$.MODULE$.apply(poolId, parent, master, fm);
    }

    public void request(HttpRequest var1, Promise<HttpResponse> var2);

    public Future<ShutdownReason> shutdown(ExecutionContext var1);

    public Future<ShutdownReason> whenShutdown();

    @InternalStableApi
    private static class Logic
    extends TimerGraphStageLogic
    implements PoolInterface,
    InHandler,
    OutHandler {
        private final PoolId poolId;
        private final PoolMaster master;
        private final Outlet<PoolFlow.RequestContext> requestOut;
        private final Inlet<PoolFlow.ResponseContext> responseIn;
        private final LoggingAdapter log;
        private final ExecutionContext executionContext;
        private final BufferOverflowException PoolOverflowException;
        private final HostConnectionPoolSetup hcps;
        private final Duration idleTimeout;
        private final Promise<ShutdownReason> shutdownPromise;
        private Option<ShutdownReason> shuttingDownReason;
        private int remainingRequested;
        private final AsyncCallback<Done> responseCompletedCallback;
        private final AsyncCallback<Tuple2<HttpRequest, Promise<HttpResponse>>> requestCallback;
        private final AsyncCallback<BoxedUnit> shutdownCallback;

        public void onDownstreamFinish() throws Exception {
            OutHandler.onDownstreamFinish$((OutHandler)this);
        }

        public void onUpstreamFinish() throws Exception {
            InHandler.onUpstreamFinish$((InHandler)this);
        }

        public HostConnectionPoolSetup hcps() {
            return this.hcps;
        }

        public Duration idleTimeout() {
            return this.idleTimeout;
        }

        public Promise<ShutdownReason> shutdownPromise() {
            return this.shutdownPromise;
        }

        public boolean shuttingDown() {
            return this.shuttingDownReason().isDefined();
        }

        public Option<ShutdownReason> shuttingDownReason() {
            return this.shuttingDownReason;
        }

        public void shuttingDownReason_$eq(Option<ShutdownReason> x$1) {
            this.shuttingDownReason = x$1;
        }

        public int remainingRequested() {
            return this.remainingRequested;
        }

        public void remainingRequested_$eq(int x$1) {
            this.remainingRequested = x$1;
        }

        public void preStart() {
            this.onInit(this.poolId);
            this.pull(this.responseIn);
            this.resetIdleTimer();
        }

        public void onTimer(Object timerKey) {
            this.log.debug(new StringBuilder(88).append("Pool shutting down because akka.http.host-connection-pool.idle-timeout triggered after ").append(this.idleTimeout()).append(".").toString());
            this.requestShutdown(PoolInterface$ShutdownReason$IdleTimeout$.MODULE$);
        }

        /*
         * Unable to fully structure code
         */
        public void onPush() {
            var5_1 = (PoolFlow.ResponseContext)this.grab(this.responseIn);
            if (var5_1 == null) {
                throw new MatchError((Object)var5_1);
            }
            rc = var5_1.rc();
            response0 = var5_1.response();
            var3_4 = new Tuple2((Object)rc, response0);
            var4_5 = var3_4;
            rc = (PoolFlow.RequestContext)var4_5._1();
            response0 = (Try)var4_5._2();
            ctx = this.onResponse(rc.request(), (Try<HttpResponse>)response0);
            var12_9 = false;
            var13_10 = null;
            var14_11 = response0;
            if (!(var14_11 instanceof Success)) ** GOTO lbl-1000
            var12_9 = true;
            var13_10 = (Success)var14_11;
            r = (HttpResponse)var13_10.value();
            if (r != null && !OptHttpResponse$.MODULE$.isEmpty$extension(var16_13 = HttpResponse$.MODULE$.unapply(r)) && !(entity = var16_13._3()).isStrict()) {
                var19_15 = StreamUtils$.MODULE$.transformEntityStream(entity, StreamUtils$CaptureTerminationOp$.MODULE$);
                if (var19_15 == null) {
                    throw new MatchError(var19_15);
                }
                newEntity = (ResponseEntity)var19_15._1();
                termination = (Future)var19_15._2();
                var2_18 = new Tuple2((Object)newEntity, (Object)termination);
                var18_19 = var2_18;
                newEntity = (ResponseEntity)var18_19._1();
                termination = (Future)var18_19._2();
                termination.onComplete((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$onPush$1$adapted(akka.http.impl.engine.client.PoolInterface$Logic scala.util.Try ), (Lscala/util/Try;)Ljava/lang/Object;)((Logic)this), this.executionContext);
                var1_22 = new Success((Object)r.withEntity(newEntity));
            } else if (var12_9) {
                response = (HttpResponse)var13_10.value();
                this.remainingRequested_$eq(this.remainingRequested() - 1);
                var1_22 = new Success((Object)response);
            } else if (var14_11 instanceof Failure) {
                this.remainingRequested_$eq(this.remainingRequested() - 1);
                var1_22 = response0;
            } else {
                throw new MatchError((Object)var14_11);
            }
            response1 = var1_22;
            rc.responsePromise().complete(response1);
            this.onResponseComplete(ctx);
            this.pull(this.responseIn);
            this.afterRequestFinished();
        }

        public void onPull() {
        }

        public AsyncCallback<Done> responseCompletedCallback() {
            return this.responseCompletedCallback;
        }

        public AsyncCallback<Tuple2<HttpRequest, Promise<HttpResponse>>> requestCallback() {
            return this.requestCallback;
        }

        public AsyncCallback<BoxedUnit> shutdownCallback() {
            return this.shutdownCallback;
        }

        public void afterRequestFinished() {
            this.shutdownIfRequestedAndPossible();
            this.resetIdleTimer();
        }

        public void requestShutdown(ShutdownReason reason) {
            this.shuttingDownReason_$eq((Option<ShutdownReason>)new Some((Object)reason));
            this.shutdownIfRequestedAndPossible();
        }

        public void shutdownIfRequestedAndPossible() {
            block2: {
                if (!this.shuttingDown()) break block2;
                if (this.remainingRequested() == 0) {
                    this.log.debug("Pool is now shutting down as requested.");
                    this.shutdownPromise().trySuccess(this.shuttingDownReason().get());
                    this.completeStage();
                } else {
                    this.log.debug(new StringBuilder(64).append("Pool is shutting down after waiting for [").append(this.remainingRequested()).append("] outstanding requests.").toString());
                }
            }
        }

        public void resetIdleTimer() {
            block0: {
                this.cancelTimer(PoolInterface$.MODULE$.akka$http$impl$engine$client$PoolInterface$$IdleTimeout());
                if (!this.shouldStopOnIdle()) break block0;
                this.scheduleOnce(PoolInterface$.MODULE$.akka$http$impl$engine$client$PoolInterface$$IdleTimeout(), (FiniteDuration)this.idleTimeout());
            }
        }

        public boolean shouldStopOnIdle() {
            return !this.shuttingDown() && this.remainingRequested() == 0 && this.idleTimeout().isFinite() && this.hcps().setup().settings().minConnections() == 0;
        }

        public void onUpstreamFailure(Throwable ex) {
            this.shutdownPromise().tryFailure(ex);
        }

        public void postStop() {
            this.shutdownPromise().tryFailure((Throwable)new IllegalStateException("Pool shutdown unexpectedly"));
        }

        @Override
        public void request(HttpRequest request, Promise<HttpResponse> responsePromise) {
            this.requestCallback().invokeWithFeedback((Object)new Tuple2((Object)request, responsePromise)).failed().foreach((Function1 & Serializable)x$6 -> {
                $this.log.debug("Request was sent to pool which was already closed, retrying through the master to create new pool instance");
                return responsePromise.tryCompleteWith($this.master.dispatchRequest($this.poolId, request, this.materializer()));
            }, this.executionContext);
        }

        @Override
        public Future<ShutdownReason> shutdown(ExecutionContext ec) {
            this.shutdownCallback().invoke((Object)BoxedUnit.UNIT);
            return this.whenShutdown();
        }

        @Override
        public Future<ShutdownReason> whenShutdown() {
            return this.shutdownPromise().future();
        }

        @InternalStableApi
        public void onInit(PoolId poolId) {
        }

        @InternalStableApi
        public HttpRequest onDispatch(HttpRequest request) {
            return request;
        }

        @InternalStableApi
        public Object onResponse(HttpRequest request, Try<HttpResponse> response) {
            return None$.MODULE$;
        }

        @InternalStableApi
        public void onResponseComplete(Object any) {
        }

        public static final /* synthetic */ void $anonfun$onPush$1(Logic $this, Try x$3) {
            $this.responseCompletedCallback().invoke((Object)Done$.MODULE$);
        }

        public static final /* synthetic */ void $anonfun$responseCompletedCallback$1(Logic $this, Done x$4) {
            $this.remainingRequested_$eq($this.remainingRequested() - 1);
            $this.afterRequestFinished();
        }

        public static final /* synthetic */ void $anonfun$requestCallback$1(Logic $this, Tuple2 x0$1) {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                HttpRequest request = (HttpRequest)tuple2._1();
                Promise responsePromise = (Promise)tuple2._2();
                if ($this.isAvailable($this.requestOut)) {
                    $this.log.debug(new StringBuilder(30).append("Dispatching request [").append(package$RichHttpRequest$.MODULE$.debugString$extension(package$.MODULE$.RichHttpRequest(request))).append("] to pool").toString());
                    String scheme = Uri$.MODULE$.httpScheme(((ConnectionContext)((Object)$this.hcps().setup().connectionContext())).isSecure());
                    Host hostHeader = Host$.MODULE$.apply($this.hcps().host(), Uri$.MODULE$.normalizePort($this.hcps().port(), scheme));
                    HttpRequest effectiveRequest = $this.onDispatch((HttpRequest)request.withUri(request.uri().toHttpRequestTargetOriginForm()).withDefaultHeaders(hostHeader, (Seq<HttpHeader>)Nil$.MODULE$));
                    int retries = request.method().isIdempotent() ? $this.hcps().setup().settings().maxRetries() : 0;
                    $this.remainingRequested_$eq($this.remainingRequested() + 1);
                    $this.resetIdleTimer();
                    $this.push($this.requestOut, new PoolFlow.RequestContext(effectiveRequest, (Promise<HttpResponse>)responsePromise, retries));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    $this.log.debug(new StringBuilder(52).append("Could not dispatch request [").append(package$RichHttpRequest$.MODULE$.debugString$extension(package$.MODULE$.RichHttpRequest(request))).append("] because buffer is full").toString());
                    responsePromise.tryFailure((Throwable)$this.PoolOverflowException);
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }

        public Logic(PoolId poolId, FlowShape<PoolFlow.ResponseContext, PoolFlow.RequestContext> shape, PoolMaster master, Outlet<PoolFlow.RequestContext> requestOut, Inlet<PoolFlow.ResponseContext> responseIn, LoggingAdapter log, ExecutionContext executionContext) {
            this.poolId = poolId;
            this.master = master;
            this.requestOut = requestOut;
            this.responseIn = responseIn;
            this.log = log;
            this.executionContext = executionContext;
            super(shape);
            InHandler.$init$((InHandler)this);
            OutHandler.$init$((OutHandler)this);
            this.PoolOverflowException = new BufferOverflowException(new StringBuilder(142).append(new StringBuilder(101).append("Exceeded configured max-open-requests value of [").append(poolId.hcps().setup().settings().maxOpenRequests()).append("]. This means that the request queue of this pool (").append(poolId.hcps()).append(") ").toString()).append("has completely filled up because the pool currently does not process requests fast enough to handle the incoming request load. ").append("Please retry the request later. See https://doc.akka.io/docs/akka-http/current/scala/http/client-side/pool-overflow.html for ").append("more information.").toString());
            this.hcps = poolId.hcps();
            this.idleTimeout = this.hcps().setup().settings().idleTimeout();
            this.shutdownPromise = Promise$.MODULE$.apply();
            this.shuttingDownReason = None$.MODULE$;
            this.remainingRequested = 0;
            this.setHandlers(responseIn, requestOut, this);
            this.responseCompletedCallback = this.getAsyncCallback((Function1 & Serializable)x$4 -> {
                Logic.$anonfun$responseCompletedCallback$1(this, x$4);
                return BoxedUnit.UNIT;
            });
            this.requestCallback = this.getAsyncCallback((Function1 & Serializable)x0$1 -> {
                Logic.$anonfun$requestCallback$1(this, x0$1);
                return BoxedUnit.UNIT;
            });
            this.shutdownCallback = this.getAsyncCallback((Function1 & Serializable)x$5 -> {
                this.requestShutdown(PoolInterface$ShutdownReason$ShutdownRequested$.MODULE$);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ Object $anonfun$onPush$1$adapted(Logic $this, Try x$3) {
            Logic.$anonfun$onPush$1($this, x$3);
            return BoxedUnit.UNIT;
        }
    }

    public static class PoolInterfaceStage
    extends GraphStageWithMaterializedValue<FlowShape<PoolFlow.ResponseContext, PoolFlow.RequestContext>, PoolInterface> {
        private final PoolId poolId;
        private final PoolMaster master;
        private final LoggingAdapter log;
        private final Outlet<PoolFlow.RequestContext> requestOut;
        private final Inlet<PoolFlow.ResponseContext> responseIn;

        private Outlet<PoolFlow.RequestContext> requestOut() {
            return this.requestOut;
        }

        private Inlet<PoolFlow.ResponseContext> responseIn() {
            return this.responseIn;
        }

        public FlowShape<PoolFlow.ResponseContext, PoolFlow.RequestContext> shape() {
            return new FlowShape(this.responseIn(), this.requestOut());
        }

        public Tuple2<GraphStageLogic, PoolInterface> createLogicAndMaterializedValue(Attributes inheritedAttributes) {
            throw new IllegalStateException("Should not be called");
        }

        public Tuple2<GraphStageLogic, PoolInterface> createLogicAndMaterializedValue(Attributes inheritedAttributes, Materializer _materializer) {
            Logic logic = new Logic(this.poolId, this.shape(), this.master, this.requestOut(), this.responseIn(), this.log, (ExecutionContext)_materializer.executionContext());
            return new Tuple2((Object)logic, (Object)logic);
        }

        public PoolInterfaceStage(PoolId poolId, PoolMaster master, LoggingAdapter log) {
            this.poolId = poolId;
            this.master = master;
            this.log = log;
            this.requestOut = Outlet$.MODULE$.apply("PoolInterface.requestOut");
            this.responseIn = Inlet$.MODULE$.apply("PoolInterface.responseIn");
        }
    }

    public static interface ShutdownReason {
    }
}

