/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.authentication;

import java.util.Collection;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.util.Assert;

public class UserDetailsServiceLdapAuthoritiesPopulator
implements LdapAuthoritiesPopulator {
    private final UserDetailsService userDetailsService;

    public UserDetailsServiceLdapAuthoritiesPopulator(UserDetailsService userService) {
        Assert.notNull((Object)userService, (String)"userDetailsService cannot be null");
        this.userDetailsService = userService;
    }

    @Override
    public Collection<? extends GrantedAuthority> getGrantedAuthorities(DirContextOperations userData, String username) {
        return this.userDetailsService.loadUserByUsername(username).getAuthorities();
    }
}

