/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.shared.common.error.StandardException;

public class StorableFormatId
extends DataType {
    private int format_id;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(StorableFormatId.class);

    @Override
    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }

    public StorableFormatId() {
    }

    public StorableFormatId(int n) {
        this.format_id = n;
    }

    public int getValue() {
        return this.format_id;
    }

    @Override
    public void setValue(int n) {
        this.format_id = n;
    }

    @Override
    public int getTypeFormatId() {
        return 93;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        FormatIdUtil.writeFormatIdInteger(objectOutput, this.format_id);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.format_id = FormatIdUtil.readFormatIdInteger(objectInput);
    }

    @Override
    public void restoreToNull() {
        this.format_id = 0;
    }

    @Override
    public int getLength() throws StandardException {
        throw StandardException.newException((String)"XSCH8.S", (Object[])new Object[0]);
    }

    @Override
    public String getString() throws StandardException {
        throw StandardException.newException((String)"XSCH8.S", (Object[])new Object[0]);
    }

    @Override
    public Object getObject() throws StandardException {
        return this;
    }

    @Override
    public DataValueDescriptor cloneValue(boolean bl) {
        return null;
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return null;
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) throws StandardException, SQLException {
        throw StandardException.newException((String)"XSCH8.S", (Object[])new Object[0]);
    }

    @Override
    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        throw StandardException.newException((String)"XSCH8.S", (Object[])new Object[0]);
    }

    @Override
    public String getTypeName() {
        return null;
    }

    @Override
    public int compare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        throw StandardException.newException((String)"XSCH8.S", (Object[])new Object[0]);
    }
}

