/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import java.nio.ByteBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.util.FileIOUtil;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.replication.ReplicatedLargeMessage;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.jboss.logging.Logger;

public final class LargeServerMessageInSync
implements ReplicatedLargeMessage {
    private static final Logger logger = Logger.getLogger(LargeServerMessageInSync.class);
    private final LargeServerMessage mainLM;
    private final StorageManager storageManager;
    private SequentialFile appendFile;
    private boolean syncDone;
    private boolean deleted;

    public LargeServerMessageInSync(StorageManager storageManager) {
        this.mainLM = storageManager.createLargeMessage();
        this.storageManager = storageManager;
    }

    public synchronized void joinSyncedData(ByteBuffer buffer) throws Exception {
        if (this.deleted) {
            return;
        }
        SequentialFile mainSeqFile = this.mainLM.getAppendFile();
        if (!mainSeqFile.isOpen()) {
            mainSeqFile.open();
        }
        try {
            if (this.appendFile != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("joinSyncedData on " + this.mainLM + ", currentSize on mainMessage=" + mainSeqFile.size() + ", appendFile size = " + this.appendFile.size()));
                }
                FileIOUtil.copyData((SequentialFile)this.appendFile, (SequentialFile)mainSeqFile, (ByteBuffer)buffer);
                this.deleteAppendFile();
            } else if (logger.isTraceEnabled()) {
                logger.trace((Object)("joinSyncedData, appendFile is null, ignoring joinSyncedData on " + this.mainLM));
            }
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.errorWhileSyncingData(this.mainLM.toString(), e);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("joinedSyncData on " + this.mainLM + " finished with " + mainSeqFile.size()));
        }
        this.syncDone = true;
    }

    public SequentialFile getSyncFile() throws ActiveMQException {
        return this.mainLM.getAppendFile();
    }

    @Override
    public Message setDurable(boolean durable) {
        this.mainLM.setDurable(durable);
        return this.mainLM.toMessage();
    }

    @Override
    public synchronized Message setMessageID(long id) {
        this.mainLM.setMessageID(id);
        return this.mainLM.toMessage();
    }

    @Override
    public synchronized void releaseResources(boolean sync, boolean sendEvent) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("release resources called on " + this.mainLM), (Throwable)new Exception("trace"));
        }
        this.mainLM.releaseResources(sync, sendEvent);
        if (this.appendFile != null && this.appendFile.isOpen()) {
            try {
                this.appendFile.close();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.largeMessageErrorReleasingResources(e);
            }
        }
    }

    @Override
    public synchronized void deleteFile() throws Exception {
        this.deleted = true;
        try {
            this.mainLM.deleteFile();
        }
        finally {
            this.deleteAppendFile();
        }
    }

    private void deleteAppendFile() throws Exception {
        if (this.appendFile != null) {
            if (this.appendFile.isOpen()) {
                this.appendFile.close();
            }
            this.appendFile.delete();
        }
    }

    @Override
    public synchronized void addBytes(byte[] bytes) throws Exception {
        if (this.deleted) {
            return;
        }
        if (this.syncDone) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Adding " + bytes.length + " towards sync message::" + this.mainLM));
            }
            this.mainLM.addBytes(bytes);
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("addBytes(bytes.length=" + bytes.length + ") on message=" + this.mainLM));
        }
        if (this.appendFile == null) {
            this.appendFile = this.storageManager.createFileForLargeMessage(this.mainLM.getMessageID(), StorageManager.LargeMessageExtension.SYNC);
        }
        if (!this.appendFile.isOpen()) {
            this.appendFile.open();
        }
        this.storageManager.addBytesToLargeMessage(this.appendFile, this.mainLM.getMessageID(), bytes);
    }

    @Override
    public void clearPendingRecordID() {
        this.mainLM.clearPendingRecordID();
    }

    @Override
    public boolean hasPendingRecord() {
        return this.mainLM.hasPendingRecord();
    }

    @Override
    public void setPendingRecordID(long pendingRecordID) {
        this.mainLM.setPendingRecordID(pendingRecordID);
    }

    @Override
    public long getPendingRecordID() {
        return this.mainLM.getPendingRecordID();
    }
}

