/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.LocalDescriptorRegistry;
import com.xebialabs.deployit.booter.local.TypeDefinitions;
import com.xebialabs.deployit.booter.local.generator.TypeGenerators;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlplatform.synthetic.TypeModificationSpecification;
import com.xebialabs.xlplatform.synthetic.TypeSpecification;
import com.xebialabs.xlplatform.synthetic.xml.SyntheticXmlDocument;
import com.xebialabs.xlplatform.utils.ClassLoaderUtils$;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.javadude.scannit.Scannit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TypeSystemBootstrapper {
    private static final String PLUGINS = File.separator + "plugins" + File.separator;
    private final Scannit scannit;
    private final TypeDefinitions typeDefinitions;
    private final TypeGenerators typeGenerators;
    private static final Logger logger = LoggerFactory.getLogger(TypeSystemBootstrapper.class);

    TypeSystemBootstrapper(LocalDescriptorRegistry registry, Scannit scannit) {
        this.scannit = scannit;
        this.typeDefinitions = new TypeDefinitions(registry);
        this.typeGenerators = new TypeGenerators(scannit);
    }

    TypeDefinitions loadTypes() {
        logger.info("Initializing type system.");
        this.scanClasses();
        this.scanSynthetics();
        this.typeDefinitions.registerTypes();
        this.typeGenerators.generateTypeDefinitions(this.typeDefinitions);
        this.typeDefinitions.registerTypes();
        return this.typeDefinitions;
    }

    private void scanClasses() {
        this.typeDefinitions.defineType(ConfigurationItem.class);
        Set cis = this.scannit.getSubTypesOf(ConfigurationItem.class);
        for (Class ci : cis) {
            this.typeDefinitions.defineType(ci);
        }
    }

    private void scanSynthetics() {
        try {
            ArrayList<TypeSpecification> types = new ArrayList<TypeSpecification>();
            ArrayList<TypeModificationSpecification> typeModifications = new ArrayList<TypeModificationSpecification>();
            this.readSynthetics("synthetic.xml", types, typeModifications);
            this.readSynthetics("synthetic-test.xml", types, typeModifications);
            types.forEach(this.typeDefinitions::defineType);
            typeModifications.forEach(this.typeDefinitions::modifyType);
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not read synthetic type definitions.", ex);
        }
    }

    private void readSynthetics(String name, List<TypeSpecification> types, List<TypeModificationSpecification> typeModifications) throws IOException {
        Enumeration<URL> syntheticXMLs = ClassLoaderUtils$.MODULE$.classLoader().getResources(name);
        for (URL syntheticXML : this.sortedResources(syntheticXMLs)) {
            logger.debug("Scanning synthetic XML: {}", (Object)syntheticXML);
            SyntheticXmlDocument syntheticXml = SyntheticXmlDocument.read(syntheticXML);
            types.addAll(syntheticXml.getTypes());
            typeModifications.addAll(syntheticXml.getTypeModifications());
        }
    }

    private List<URL> sortedResources(Enumeration<URL> syntheticXMLs) {
        ArrayList<URL> files = Collections.list(syntheticXMLs);
        return Stream.concat(this.allButPlugins(files), this.sortedPlugins(files)).collect(Collectors.toList());
    }

    private Stream<URL> allButPlugins(List<URL> files) {
        return files.stream().filter(this.filterByFolder(PLUGINS).negate());
    }

    private Predicate<URL> filterByFolder(String s) {
        return p -> this.decode((URL)p).contains(s);
    }

    private String decode(URL url) {
        String decodedString = "";
        try {
            decodedString = URLDecoder.decode(url.getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return decodedString;
    }

    private Stream<URL> sortedPlugins(List<URL> files) {
        return files.stream().filter(this.filterByFolder(PLUGINS)).sorted(this::sortByPluginFolderName);
    }

    private int sortByPluginFolderName(URL url1, URL url2) {
        return this.getPluginFolderName(url1).compareTo(this.getPluginFolderName(url2));
    }

    private String getPluginFolderName(URL url) {
        String path = this.decode(url);
        return path.substring(path.lastIndexOf(PLUGINS) + PLUGINS.length());
    }
}

