/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.orchestrator;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.xebialabs.deployit.deployment.planner.MultiDeltaSpecificationHelper;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecificationWithDependencies;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.ProvisioningPackage;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class DescriptionHelper {
    private static Map<Operation, String> deploymentVerbs = ImmutableMap.of((Object)Operation.CREATE, (Object)"Deploy", (Object)Operation.DESTROY, (Object)"Undeploy", (Object)Operation.MODIFY, (Object)"Update", (Object)Operation.NOOP, (Object)"Not update");
    private static Map<Operation, String> provisioningVerbs = ImmutableMap.of((Object)Operation.CREATE, (Object)"Provision", (Object)Operation.DESTROY, (Object)"Deprovision", (Object)Operation.MODIFY, (Object)"Update", (Object)Operation.NOOP, (Object)"Not update");
    private static Joiner joinWithSpaces = Joiner.on((String)" ");

    private DescriptionHelper() {
    }

    public static String getDescriptionForSpecWithDependencies(DeltaSpecificationWithDependencies specs) {
        return DescriptionHelper.getDescriptionForSpecs(specs.getAllDeltaSpecifications());
    }

    public static String getDescriptionForSpecs(List<DeltaSpecification> allDeltaSpecifications) {
        String appAndVersionNames = allDeltaSpecifications.stream().map(MultiDeltaSpecificationHelper::correctDeployedApplication).map(da -> da.getName() + " " + da.getVersion().getVersion()).collect(Collectors.joining(", "));
        String environmentName = allDeltaSpecifications.stream().map(MultiDeltaSpecificationHelper::correctDeployedApplication).findAny().map(DeployedApplication::getEnvironment).map(BaseConfigurationItem::getName).orElse("No Environment");
        String verb = allDeltaSpecifications.stream().map(MultiDeltaSpecificationHelper::correctDeployedApplication).findFirst().map(DeployedApplication::getVersion).filter(version -> version instanceof ProvisioningPackage).map(pp -> provisioningVerbs.get(MultiDeltaSpecificationHelper.commonOperation(allDeltaSpecifications).orElse(Operation.CREATE))).orElseGet(() -> deploymentVerbs.get(MultiDeltaSpecificationHelper.commonOperation(allDeltaSpecifications).orElse(Operation.CREATE)));
        return joinWithSpaces.join((Object)verb, (Object)appAndVersionNames, new Object[]{"on", environmentName});
    }

    public static String getDescriptionForSpec(DeltaSpecification specification) {
        DeployedApplication deployedApplication = specification.getDeployedApplication();
        return joinWithSpaces.join((Object)DescriptionHelper.verb(specification, deployedApplication), (Object)deployedApplication.getName(), new Object[]{deployedApplication.getVersion().getName(), "on", deployedApplication.getEnvironment().getName()});
    }

    private static String verb(DeltaSpecification specification, DeployedApplication deployedApplication) {
        if (deployedApplication.getVersion() instanceof ProvisioningPackage) {
            return provisioningVerbs.get(specification.getOperation());
        }
        return deploymentVerbs.get(specification.getOperation());
    }

    public static String getDescriptionForContainer(Operation op, Container con) {
        return joinWithSpaces.join((Object)deploymentVerbs.get(op), (Object)"on", new Object[]{con.getName()});
    }

    public static String getDescriptionForPackage(Operation op, Version version) {
        return joinWithSpaces.join((Object)deploymentVerbs.get(op), (Object)"package", new Object[]{version.getApplication().getName(), version.getName()});
    }
}

